/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.helpers;

import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.mods.botania.Botania;
import modtweaker2.mods.mekanism.MekanismHelper;
import modtweaker2.mods.mekanism.gas.IGasStack;
import modtweaker2.utils.TweakerPlugin;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class StackHelper {
    public static boolean areEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (TweakerPlugin.isLoaded("Botania") && Botania.isSubtile(stack1) && Botania.isSubtile(stack2)) {
            return Botania.subtileMatches(stack1, stack2);
        }
        return stack1.func_77969_a(stack2);
    }

    public static boolean areEqual(FluidStack stack1, FluidStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.isFluidEqual(stack2);
    }

    public static boolean areEqualOrNull(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return StackHelper.areEqual(stack1, stack2);
    }

    public static boolean areEqualOrNull(FluidStack stack1, FluidStack stack2) {
        if (stack1 == stack2) {
            return true;
        }
        return StackHelper.areEqual(stack1, stack2);
    }

    public static boolean matches(IIngredient ingredient, IItemStack itemStack) {
        if (ingredient == null) {
            return false;
        }
        if (!ingredient.matches(itemStack)) {
            return false;
        }
        if (ingredient.getItems() != null && TweakerPlugin.isLoaded("Botania") && Botania.isSubtile(InputHelper.toStack(itemStack))) {
            for (IItemStack item : ingredient.getItems()) {
                if (!StackHelper.areEqual(InputHelper.toStack(item), InputHelper.toStack(itemStack))) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean matches(IIngredient ingredient, ILiquidStack liquidStack) {
        if (ingredient == null) {
            return false;
        }
        if (ingredient.matches(liquidStack)) {
            return true;
        }
        if (ingredient.getLiquids() != null) {
            for (ILiquidStack liquid : ingredient.getLiquids()) {
                if (!InputHelper.toFluid(liquid).isFluidEqual(InputHelper.toFluid(liquidStack))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(IIngredient ingredient, IGasStack gasStack) {
        if (ingredient == null) {
            return false;
        }
        if (ingredient == IngredientAny.INSTANCE) {
            return true;
        }
        if (ingredient instanceof IGasStack) {
            return MekanismHelper.toGas((IGasStack)ingredient).isGasEqual(MekanismHelper.toGas(gasStack));
        }
        return false;
    }
}

