/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import thaumicenergistics.common.utils.ThEUtils;

public class TheInternalInventory
implements IInventory {
    private static final String NBT_KEY_SLOT = "Slot";
    private final int stackLimit;
    private final ItemStack[] slots;
    private final String customName;

    public TheInternalInventory(String customName, int size, int stackLimit) {
        this.slots = new ItemStack[size];
        this.customName = customName;
        this.stackLimit = stackLimit;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        ItemStack slotStack = this.slots[slotIndex];
        ItemStack resultStack = null;
        if (slotStack == null) {
            return null;
        }
        int decAmount = Math.min(amount, slotStack.field_77994_a);
        if (decAmount > 0) {
            resultStack = slotStack.func_77946_l();
            resultStack.field_77994_a = decAmount;
        }
        slotStack.field_77994_a -= decAmount;
        if (slotStack.field_77994_a > 0) {
            this.func_70299_a(slotIndex, slotStack);
        } else {
            this.func_70299_a(slotIndex, null);
        }
        return resultStack;
    }

    public boolean getHasStack(int slotIndex) {
        return this.slots[slotIndex] != null;
    }

    public String func_145825_b() {
        return this.customName;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.slots[slotIndex];
    }

    public ItemStack func_70304_b(int slotIndex) {
        return this.slots[slotIndex];
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int incrStackSize(int slotIndex, int amount) {
        int stackLimit;
        ItemStack slotStack = this.slots[slotIndex];
        int added = 0;
        if (slotStack != null && (added = Math.min(amount, (stackLimit = Math.min(this.func_70297_j_(), slotStack.func_77976_d())) - slotStack.field_77994_a)) > 0) {
            this.slots[slotIndex].field_77994_a += added;
            this.func_70296_d();
        }
        return added;
    }

    public boolean isEmpty() {
        for (int index = 0; index < this.slots.length; ++index) {
            if (this.slots[index] == null) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return false;
    }

    @Deprecated
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean isUseableByPlayer(@Nonnull EntityPlayer player, @Nonnull TileEntity tile) {
        return ThEUtils.canPlayerInteractWith(player, tile);
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public final void readFromNBT(NBTTagCompound data, String tagName) {
        if (data == null) {
            return;
        }
        if (!data.func_74764_b(tagName)) {
            return;
        }
        NBTTagList invList = data.func_150295_c(tagName, 10);
        for (int index = 0; index < invList.func_74745_c(); ++index) {
            NBTTagCompound nbtCompound = invList.func_150305_b(index);
            int slotIndex = nbtCompound.func_74771_c(NBT_KEY_SLOT) & 0xFF;
            if (slotIndex < 0 || slotIndex >= this.slots.length) continue;
            this.slots[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)nbtCompound);
        }
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.slots[slotIndex] = itemStack;
        this.func_70296_d();
    }

    public final void writeToNBT(NBTTagCompound data, String tagName) {
        if (data == null) {
            return;
        }
        NBTTagList invList = new NBTTagList();
        for (int slotIndex = 0; slotIndex < this.slots.length; ++slotIndex) {
            if (this.slots[slotIndex] == null) continue;
            NBTTagCompound nbtCompound = new NBTTagCompound();
            nbtCompound.func_74774_a(NBT_KEY_SLOT, (byte)slotIndex);
            this.slots[slotIndex].func_77955_b(nbtCompound);
            invList.func_74742_a((NBTBase)nbtCompound);
        }
        if (invList.func_74745_c() > 0) {
            data.func_74782_a(tagName, (NBTBase)invList);
        }
    }
}

