/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import java.util.Arrays;
import java.util.List;
import kubatech.api.Variables;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.loaders.BlockLoader;
import kubatech.loaders.DEFCRecipes;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_DEFusionCrafter
extends KubaTechGTMultiBlockBase<GT_MetaTileEntity_DEFusionCrafter>
implements ISurvivalConstructable {
    private static final int CASING_INDEX = 191;
    private int mTierCasing = 0;
    private int mFusionTierCasing = 0;
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final List<Pair<Block, Integer>> fusionCasingTiers = Arrays.asList(Pair.of((Object)GregTech_API.sBlockCasings4, (Object)6), Pair.of((Object)GregTech_API.sBlockCasings4, (Object)8));
    private static final List<Pair<Block, Integer>> coreTiers = Arrays.asList(Pair.of((Object)((Object)BlockLoader.defcCasingBlock), (Object)8), Pair.of((Object)((Object)BlockLoader.defcCasingBlock), (Object)9), Pair.of((Object)((Object)BlockLoader.defcCasingBlock), (Object)10), Pair.of((Object)((Object)BlockLoader.defcCasingBlock), (Object)11), Pair.of((Object)((Object)BlockLoader.defcCasingBlock), (Object)12));
    private static final IStructureDefinition<GT_MetaTileEntity_DEFusionCrafter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"nnnnn", "nnnnn", "nnnnn", "nnnnn", "nnnnn"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"RRRRR", "R F R", "RFfFR", "R F R", "RRRRR"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"RRRRR", "R F R", "RFfFR", "R F R", "RRRRR"}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"     ", "  F  ", " FfF ", "  F  ", "     "}, {"NN~NN", "NNNNN", "NNNNN", "NNNNN", "NNNNN"}})).addElement('N', (IStructureElement)GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_DEFusionCrafter.class).atLeast(new IHatchElement[]{GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Energy, GT_HatchElement.Maintenance}).casingIndex(191).dot(1).buildAndChain(new IStructureElement[]{StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)BlockLoader.defcCasingBlock, (int)7))})).addElement('n', StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)BlockLoader.defcCasingBlock, (int)7))).addElement('f', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)7)).addElement('F', StructureUtility.ofBlocksTiered((b, m) -> {
        if (b != GregTech_API.sBlockCasings4 || m != 6 && m != 8) {
            return -2;
        }
        return m == 6 ? 1 : 2;
    }, fusionCasingTiers, (Object)-1, (e, i) -> {
        e.mFusionTierCasing = i;
    }, e -> e.mFusionTierCasing)).addElement('R', StructureUtility.ofBlocksTiered((b, m) -> {
        if (b != BlockLoader.defcCasingBlock || m < 8 || m > 12) {
            return -2;
        }
        return m - 7;
    }, coreTiers, (Object)-1, (e, i) -> {
        e.mTierCasing = i;
    }, e -> e.mTierCasing)).build();

    public GT_MetaTileEntity_DEFusionCrafter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_DEFusionCrafter(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DEFusionCrafter(this.mName);
    }

    public IStructureDefinition<GT_MetaTileEntity_DEFusionCrafter> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mTierCasing = -1;
        this.mFusionTierCasing = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 9, 0)) {
            return false;
        }
        if (this.mCasing < 19) {
            return false;
        }
        if (this.mTierCasing == -2 || this.mFusionTierCasing == -2) {
            return false;
        }
        if (this.mTierCasing > 3 && this.mFusionTierCasing < 2) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fusion Crafter").addInfo("Controller Block for the Draconic Evolution Fusion Crafter").addInfo(Variables.buildAuthorList("kuba6000", "Prometheus0000")).addInfo("Machine can be overclocked by using casings above the recipe tier:").addInfo("Recipe time is divided by number of tiers above the recipe").addInfo("Normal EU OC still applies !").addInfo(Variables.StructureHologram).addSeparator().beginStructureBlock(5, 10, 5, false).addController("Front bottom center").addCasingInfoMin("Naquadah Alloy Fusion Casing", 19, false).addOtherStructurePart("Fusion Coil Block", "Center pillar").addOtherStructurePart("Fusion Machine Casing", "Touching Fusion Coil Block at every side").addOtherStructurePart("Tiered Fusion Casing", "Rings (5x5 hollow) at layer 4 and 7").addStructureInfo("Bloody Ichorium for tier 1, Draconium for tier 2, etc").addStructureInfo("To use tier 3 + you have to use fusion casing MK II").addInputBus("Any bottom casing", new int[]{1}).addInputHatch("Any bottom casing", new int[]{1}).addOutputBus("Any bottom casing", new int[]{1}).addOutputHatch("Any bottom casing", new int[]{1}).addEnergyHatch("Any bottom casing", new int[]{1}).addMaintenanceHatch("Any bottom casing", new int[]{1}).toolTipFinisher("KubaTech");
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TELEPORTER_GLOW}).extFacing().glow().build()};
        }
        if (aActive) {
            return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.MACHINE_CASING_MAGIC), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.MACHINE_CASING_MAGIC_GLOW}).extFacing().glow().build()};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public RecipeMap<?> getRecipeMap() {
        return DEFCRecipes.fusionCraftingRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GT_Recipe recipe) {
                return recipe.mSpecialValue <= GT_MetaTileEntity_DEFusionCrafter.this.mTierCasing ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.NO_RECIPE;
            }

            protected double calculateDuration(@NotNull GT_Recipe recipe, @NotNull GT_ParallelHelper helper, @NotNull GT_OverclockCalculator calculator) {
                return Math.max(1.0, super.calculateDuration(recipe, helper, calculator) / (double)(GT_MetaTileEntity_DEFusionCrafter.this.mTierCasing - recipe.mSpecialValue + 1));
            }
        };
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 9, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 9, 0, elementBudget, env, true, true);
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public boolean supportsInputSeparation() {
        return true;
    }
}

