/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEItemStack;
import com.glodblock.github.client.gui.container.ContainerLevelMaintainer;
import com.glodblock.github.network.SPacketMEUpdateBuffer;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;

public class CPacketLevelMaintainer
implements IMessage {
    private Action action;
    private long size;
    private int slotIndex;

    public CPacketLevelMaintainer() {
        this.action = Action.Refresh;
        this.slotIndex = 0;
        this.size = 0L;
    }

    public CPacketLevelMaintainer(Action action) {
        this.action = action;
        this.slotIndex = 0;
        this.size = 0L;
    }

    public CPacketLevelMaintainer(Action action, int slotIndex) {
        this.action = action;
        this.slotIndex = slotIndex;
        this.size = 0L;
    }

    public CPacketLevelMaintainer(Action action, int slotIndex, long size) {
        this.action = action;
        this.slotIndex = slotIndex;
        this.size = size;
    }

    public CPacketLevelMaintainer(Action action, int slotIndex, String size) {
        this.action = action;
        this.slotIndex = slotIndex;
        this.size = size.isEmpty() ? 0L : Long.parseLong(size);
    }

    public void fromBytes(ByteBuf buf) {
        this.action = Action.values()[buf.readInt()];
        this.slotIndex = buf.readInt();
        this.size = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.slotIndex);
        buf.writeLong(this.size);
    }

    public static enum Action {
        Refresh,
        Quantity,
        Batch,
        Enable,
        Disable;

    }

    public static class Handler
    implements IMessageHandler<CPacketLevelMaintainer, IMessage> {
        private List<IAEItemStack> refresh(ContainerLevelMaintainer cca) {
            ArrayList<IAEItemStack> toSend = new ArrayList<IAEItemStack>(5);
            for (int i = 0; i < 5; ++i) {
                IAEItemStack ias = cca.getTile().requests.getAEItemStack(i);
                if (ias == null) continue;
                toSend.add(ias);
            }
            return toSend;
        }

        @Nullable
        public IMessage onMessage(CPacketLevelMaintainer message, MessageContext ctx) {
            Container container = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (container instanceof ContainerLevelMaintainer) {
                List<IAEItemStack> list;
                ContainerLevelMaintainer clm = (ContainerLevelMaintainer)container;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                switch (message.action) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case Quantity: {
                        clm.getTile().updateQuantity(message.slotIndex, message.size);
                        list = this.refresh(clm);
                        break;
                    }
                    case Batch: {
                        clm.getTile().updateBatchSize(message.slotIndex, message.size);
                        list = this.refresh(clm);
                        break;
                    }
                    case Enable: {
                        clm.getTile().updateStatus(message.slotIndex, false);
                        list = this.refresh(clm);
                        break;
                    }
                    case Disable: {
                        clm.getTile().updateStatus(message.slotIndex, true);
                        list = this.refresh(clm);
                        break;
                    }
                    case Refresh: {
                        list = this.refresh(clm);
                    }
                }
                List<IAEItemStack> toSend = list;
                SPacketMEUpdateBuffer.scheduleItemUpdate(player, toSend);
            }
            return null;
        }
    }
}

