/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.coremod.registries.adapters;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.parts.automation.PartLevelEmitter;
import appeng.util.item.AEItemStack;
import com.glodblock.github.api.registries.ILevelViewable;
import com.glodblock.github.api.registries.ILevelViewableAdapter;
import com.glodblock.github.common.tile.TileLevelMaintainer;
import com.glodblock.github.inventory.AeItemStackHandler;
import com.glodblock.github.inventory.AeStackInventoryImpl;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class PartLevelEmitterAdapter
implements ILevelViewable,
ILevelViewableAdapter {
    private PartLevelEmitter delegate;
    private static final int SLOT_IN = 0;

    @Override
    public ILevelViewable adapt(IGridHost gridHost) {
        if (gridHost instanceof PartLevelEmitter) {
            PartLevelEmitter levelEmitter;
            this.delegate = levelEmitter = (PartLevelEmitter)gridHost;
        }
        return this;
    }

    @NotNull
    public static IInventory getPatchedInventory(IInventory inventory, long quantity, TileLevelMaintainer.State state) {
        ItemStack itemStack = inventory.func_70301_a(0);
        if (itemStack == null) {
            return inventory;
        }
        NBTTagCompound data = !itemStack.func_77942_o() ? new NBTTagCompound() : itemStack.func_77978_p();
        data.func_74772_a(TileLevelMaintainer.TLMTags.Quantity.tagName, quantity);
        data.func_74768_a(TileLevelMaintainer.TLMTags.State.tagName, state.ordinal());
        itemStack.func_77982_d(data);
        AeStackInventoryImpl<IAEItemStack> inv = new AeStackInventoryImpl<IAEItemStack>(StorageChannel.ITEMS, 1);
        inv.setStack(0, (IAEItemStack)AEItemStack.create((ItemStack)itemStack));
        return new AeItemStackHandler(inv);
    }

    @Override
    public DimensionalCoord getLocation() {
        return this.delegate.getLocation();
    }

    @Override
    public TileEntity getTile() {
        return this.delegate.getTile();
    }

    public IInventory getInventoryByName(String name) {
        long value = this.delegate.getReportingValue();
        TileLevelMaintainer.State state = this.delegate.isProvidingStrongPower() > 0 ? TileLevelMaintainer.State.Craft : TileLevelMaintainer.State.Idle;
        return PartLevelEmitterAdapter.getPatchedInventory(this.delegate.getInventoryByName(name), value, state);
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.delegate.getGridNode(dir);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return this.delegate.getCableConnectionType(dir);
    }

    @Override
    public ForgeDirection getSide() {
        return this.delegate.getSide();
    }

    public void securityBreak() {
        this.delegate.securityBreak();
    }

    public String getCustomName() {
        return this.delegate.getCustomName();
    }

    public boolean hasCustomName() {
        return this.delegate.hasCustomName();
    }

    public void setCustomName(String name) {
        this.delegate.hasCustomName();
    }

    @Override
    public ItemStack getSelfItemStack() {
        return this.delegate.getItemStack();
    }

    @Override
    public ItemStack getDisplayItemStack() {
        return this.delegate.getCrafterIcon();
    }
}

