/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.tiles.IViewCellStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.me.helpers.ChannelPowerSrc;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.base.FCContainerMonitor;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.network.CPacketFluidUpdate;
import com.glodblock.github.network.SPacketFluidUpdate;
import com.glodblock.github.network.SPacketMEUpdateBuffer;
import com.glodblock.github.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ContainerFluidMonitor
extends FCContainerMonitor<IAEFluidStack> {
    protected final IItemList<IAEFluidStack> fluids = AEApi.instance().storage().createFluidList();
    protected static final int REM_IDX = 0;
    protected static final int ACT_IDX = 1;
    protected static final int PARTIAL_IDX = 2;

    public ContainerFluidMonitor(InventoryPlayer ip, ITerminalHost monitorable) {
        this(ip, monitorable, true);
    }

    protected ContainerFluidMonitor(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable, bindInventory);
        if (Platform.isServer()) {
            this.serverCM = monitorable.getConfigManager();
            if (monitorable instanceof IGridHost) {
                IGridNode node = ((IGridHost)monitorable).getGridNode(ForgeDirection.UNKNOWN);
                if (node != null) {
                    this.networkNode = node;
                    IGrid g = node.getGrid();
                    if (g != null) {
                        this.setPowerSource((IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)g.getCache(IEnergyGrid.class)));
                        IStorageGrid storageGrid = (IStorageGrid)g.getCache(IStorageGrid.class);
                        this.monitor = storageGrid.getFluidInventory();
                        if (this.monitor == null) {
                            this.setValidContainer(false);
                        } else {
                            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                        }
                    }
                } else {
                    this.setValidContainer(false);
                }
            } else {
                this.monitor = monitorable.getFluidInventory();
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setPowerSource((IEnergySource)monitorable);
            }
        } else {
            this.monitor = null;
        }
        this.canAccessViewCells = false;
        if (monitorable instanceof IViewCellStorage) {
            for (int y = 0; y < 5; ++y) {
                this.cellView[y] = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.VIEW_CELL, ((IViewCellStorage)monitorable).getViewCellStorage(), y, 206, y * 18 + 8, this.getInventoryPlayer());
                this.cellView[y].setAllowEdit(this.canAccessViewCells);
                this.func_75146_a((Slot)this.cellView[y]);
            }
        }
        if (bindInventory) {
            this.bindPlayerInventory(ip, 0, 0);
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        Slot clickSlot;
        if (Platform.isClient() && !this.isEssentiaMode() && ((clickSlot = (Slot)this.field_75151_b.get(idx)) instanceof SlotPlayerInv || clickSlot instanceof SlotPlayerHotBar) && clickSlot.func_75216_d() && Util.FluidUtil.isFluidContainer(clickSlot.func_75211_c())) {
            ItemStack tis = clickSlot.func_75211_c();
            HashMap<Integer, IAEFluidStack> tmp = new HashMap<Integer, IAEFluidStack>();
            tmp.put(0, ItemFluidDrop.getAeFluidStack((IAEItemStack)AEItemStack.create((ItemStack)tis)));
            int index = Util.findItemInPlayerInvSlot(p, clickSlot.func_75211_c());
            FluidCraft.proxy.netHandler.sendToServer(new CPacketFluidUpdate(tmp, tis, index));
        }
        return super.func_82846_b(p, idx);
    }

    @Override
    protected void processItemList() {
        if (!this.fluids.isEmpty()) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEFluidStack> toSend = new ArrayList<IAEFluidStack>();
            for (IAEFluidStack is : this.fluids) {
                IAEFluidStack send = (IAEFluidStack)monitorCache.findPrecise((IAEStack)is);
                if (send != null) {
                    toSend.add(send);
                    continue;
                }
                is.setStackSize(0L);
                toSend.add(is);
            }
            for (Object c : this.field_75149_d) {
                if (!(c instanceof EntityPlayerMP)) continue;
                SPacketMEUpdateBuffer.scheduleFluidUpdate((EntityPlayerMP)c, toSend);
            }
            this.fluids.resetStatus();
        }
    }

    @Override
    protected void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayerMP && this.monitor != null) {
            IItemList monitorCache = this.monitor.getStorageList();
            ArrayList<IAEFluidStack> toSend = new ArrayList<IAEFluidStack>();
            for (IAEFluidStack is : monitorCache) {
                toSend.add(is);
            }
            SPacketMEUpdateBuffer.scheduleFluidUpdate((EntityPlayerMP)c, toSend);
        }
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        for (IAEFluidStack is : change) {
            this.fluids.add((IAEStack)is);
        }
    }

    protected void dropItem(ItemStack is) {
        if (is == null || is.field_77994_a <= 0) {
            return;
        }
        ItemStack itemStack = is.func_77946_l();
        int i = itemStack.func_77976_d();
        while (itemStack.field_77994_a > 0) {
            if (i > itemStack.field_77994_a) {
                if (this.getPlayerInv().func_70441_a(itemStack.func_77946_l())) break;
                this.getPlayerInv().field_70458_d.func_70099_a(itemStack.func_77946_l(), 0.0f);
                break;
            }
            itemStack.field_77994_a -= i;
            ItemStack item = itemStack.func_77946_l();
            item.field_77994_a = i;
            if (this.getPlayerInv().func_70441_a(item)) continue;
            this.getPlayerInv().field_70458_d.func_70099_a(item, 0.0f);
        }
    }

    protected void dropItem(ItemStack itemStack, int stackSize) {
        if (itemStack == null || itemStack.field_77994_a <= 0) {
            return;
        }
        ItemStack is = itemStack.func_77946_l();
        is.field_77994_a = stackSize;
        this.dropItem(is);
    }

    public void postChange(Iterable<IAEFluidStack> change, ItemStack fluidContainer, EntityPlayer player, int slotIndex) {
        int cursorItems = slotIndex == -1 ? player.field_71071_by.func_70445_o().field_77994_a : player.field_71071_by.func_70301_a((int)slotIndex).field_77994_a;
        for (IAEFluidStack fluid : change) {
            if (Util.FluidUtil.isEmpty(fluidContainer) && fluid != null) {
                this.extractFluid(fluid, fluidContainer, player, cursorItems);
                continue;
            }
            if (Util.FluidUtil.isEmpty(fluidContainer)) continue;
            this.insertFluid(fluidContainer, player, slotIndex, cursorItems);
        }
        this.func_75142_b();
    }

    private int insertME(IAEFluidStack canSend, int[] results, int numTanks, int fluidInTank) {
        IAEFluidStack notInserted = (IAEFluidStack)this.host.getFluidInventory().injectItems((IAEStack)canSend, Actionable.MODULATE, this.getActionSource());
        if (notInserted != null && notInserted.getStackSize() > 0L) {
            if (canSend.getStackSize() == notInserted.getStackSize()) {
                results[0] = numTanks;
                return fluidInTank;
            }
            results[0] = (int)(notInserted.getStackSize() / (long)fluidInTank);
            results[1] = numTanks - results[0];
            int remainder = (int)(notInserted.getStackSize() % (long)fluidInTank);
            if (remainder > 0) {
                results[2] = 1;
                results[1] = results[1] - 1;
                return remainder;
            }
            results[2] = 0;
        } else {
            results[0] = 0;
            results[1] = numTanks;
            results[2] = 0;
        }
        return 0;
    }

    private void insertFluid(ItemStack fluidContainer, EntityPlayer player, int slotIndex, int heldContainers) {
        ItemStack partialStack = null;
        ItemStack emptyStack = null;
        int[] insertionResults = new int[3];
        Item item = fluidContainer.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem fcItem = (IFluidContainerItem)item;
            AEFluidStack canSend = AEFluidStack.create((Object)fcItem.getFluid(fluidContainer));
            int fluidPerContainer = (int)canSend.getStackSize();
            canSend.setStackSize((long)fluidPerContainer * (long)fluidContainer.field_77994_a);
            ItemStack test = fluidContainer.func_77946_l();
            test.field_77994_a = 1;
            FluidStack fluidStack = fcItem.drain(test, fluidPerContainer, false);
            if (fluidStack == null || fluidStack.amount == 0) {
                return;
            }
            int partialAmount = this.insertME((IAEFluidStack)canSend, insertionResults, fluidContainer.field_77994_a, fluidPerContainer);
            if (insertionResults[2] > 0) {
                partialStack = fluidContainer.func_77946_l();
                partialStack.field_77994_a = 1;
                fcItem.drain(partialStack, fluidPerContainer - partialAmount, true);
            }
            if (insertionResults[1] > 0) {
                emptyStack = fluidContainer.func_77946_l();
                emptyStack.field_77994_a = 1;
                fcItem.drain(emptyStack, fluidPerContainer, true);
                emptyStack.field_77994_a = insertionResults[1];
            }
        } else if (FluidContainerRegistry.isContainer((ItemStack)fluidContainer)) {
            AEFluidStack canSend = AEFluidStack.create((Object)FluidContainerRegistry.getFluidForFilledItem((ItemStack)fluidContainer));
            int fluidPerContainer = (int)canSend.getStackSize();
            canSend.setStackSize((long)fluidPerContainer * (long)fluidContainer.field_77994_a);
            ItemStack emptyTank = FluidContainerRegistry.drainFluidContainer((ItemStack)fluidContainer);
            if (emptyTank == null) {
                return;
            }
            int partialAmount = this.insertME((IAEFluidStack)canSend, insertionResults, fluidContainer.field_77994_a, fluidPerContainer);
            if (partialAmount > 0) {
                int extract = FluidContainerRegistry.getContainerCapacity((ItemStack)fluidContainer) - partialAmount;
                if (extract > 0) {
                    IAEFluidStack toExtract = (IAEFluidStack)canSend.copy().setStackSize((long)extract);
                    this.host.getFluidInventory().extractItems((IAEStack)toExtract, Actionable.MODULATE, this.getActionSource());
                }
                insertionResults[2] = 0;
            }
            if (insertionResults[1] > 0) {
                emptyStack = FluidContainerRegistry.drainFluidContainer((ItemStack)fluidContainer);
                emptyStack.field_77994_a = insertionResults[1];
            }
        } else {
            return;
        }
        boolean shouldSendStack = true;
        int emptyTanks = insertionResults[1];
        int extraTanks = heldContainers - emptyTanks - insertionResults[2];
        if (slotIndex == -1) {
            if (extraTanks > 0) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                stack.field_77994_a = extraTanks;
                this.adjustStack(stack);
                this.dropItem(emptyStack);
                this.dropItem(partialStack);
            } else if (emptyTanks != 0) {
                this.adjustStack(emptyStack);
                player.field_71071_by.func_70437_b(emptyStack);
                this.dropItem(partialStack);
            } else if (partialStack != null) {
                player.field_71071_by.func_70437_b(partialStack);
            } else {
                player.field_71071_by.func_70437_b(null);
                shouldSendStack = false;
            }
        } else {
            ItemStack stack = player.field_71071_by.func_70301_a(slotIndex);
            if (extraTanks > 0) {
                stack.field_77994_a = extraTanks;
                this.adjustStack(stack);
                this.dropItem(emptyStack);
                this.dropItem(partialStack);
            } else if (emptyTanks != 0) {
                this.adjustStack(emptyStack);
                player.field_71071_by.func_70299_a(slotIndex, emptyStack);
                this.dropItem(partialStack);
            } else if (partialStack != null) {
                player.field_71071_by.func_70299_a(slotIndex, partialStack);
            } else {
                player.field_71071_by.func_70437_b(null);
                shouldSendStack = false;
            }
        }
        if (shouldSendStack) {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>(), player.field_71071_by.func_70445_o()), (EntityPlayerMP)player);
        } else {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>()), (EntityPlayerMP)player);
        }
    }

    private void extractFluid(IAEFluidStack fluid, ItemStack fluidContainer, EntityPlayer player, int heldContainers) {
        IAEFluidStack storedFluid;
        Item item = fluidContainer.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem fcItem = (IFluidContainerItem)item;
            ItemStack testStack = fluidContainer.func_77946_l();
            testStack.field_77994_a = 1;
            int test = fcItem.fill(testStack, fluid.getFluidStack(), false);
            if (test == 0) {
                return;
            }
        } else if (FluidContainerRegistry.isContainer((ItemStack)fluidContainer)) {
            ItemStack test = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid.getFluidStack(), (ItemStack)fluidContainer);
            if (test == null) {
                return;
            }
        } else {
            return;
        }
        if ((storedFluid = (IAEFluidStack)this.monitor.getStorageList().findPrecise((IAEStack)fluid)) == null || storedFluid.getStackSize() <= 0L) {
            return;
        }
        int capacity = Util.FluidUtil.getCapacity(fluidContainer, storedFluid.getFluid());
        if (capacity == 0) {
            return;
        }
        IAEFluidStack canExtract = storedFluid.copy();
        canExtract.setStackSize((long)capacity * (long)fluidContainer.field_77994_a);
        IAEFluidStack actualExtract = (IAEFluidStack)this.host.getFluidInventory().extractItems((IAEStack)canExtract, Actionable.MODULATE, this.getActionSource());
        if (actualExtract == null) {
            return;
        }
        long toExtract = actualExtract.getStackSize();
        int filledTanks = (int)(toExtract / (long)capacity);
        int remainder = (int)(toExtract % (long)capacity);
        int emptyTanks = heldContainers - filledTanks;
        ItemStack filledStack = fluidContainer.func_77946_l();
        filledStack.field_77994_a = 1;
        if (filledTanks > 0) {
            if (filledStack.func_77973_b() instanceof IFluidContainerItem) {
                int amt = ((IFluidContainerItem)filledStack.func_77973_b()).fill(filledStack, actualExtract.getFluidStack(), true);
                assert (amt == capacity);
            } else {
                filledStack = FluidContainerRegistry.fillFluidContainer((FluidStack)actualExtract.getFluidStack(), (ItemStack)filledStack);
                assert (capacity == FluidContainerRegistry.getContainerCapacity((ItemStack)filledStack));
            }
            filledStack.field_77994_a = filledTanks;
        } else {
            filledStack.field_77994_a = 0;
        }
        ItemStack partialStack = fluidContainer.func_77946_l();
        if (remainder > 0) {
            actualExtract.setStackSize((long)remainder);
            partialStack.field_77994_a = 1;
            if (partialStack.func_77973_b() instanceof IFluidContainerItem) {
                int amt = ((IFluidContainerItem)partialStack.func_77973_b()).fill(partialStack, actualExtract.getFluidStack(), true);
                assert (amt == remainder);
                --emptyTanks;
            } else {
                ItemStack dummy = FluidContainerRegistry.fillFluidContainer((FluidStack)actualExtract.getFluidStack(), (ItemStack)partialStack);
                if (dummy == null) {
                    partialStack.field_77994_a = 0;
                } else {
                    partialStack = dummy;
                    --emptyTanks;
                }
            }
        } else {
            partialStack.field_77994_a = 0;
        }
        boolean shouldSendStack = true;
        if (emptyTanks > 0) {
            ItemStack emptyStack = player.field_71071_by.func_70445_o();
            emptyStack.field_77994_a = emptyTanks;
            this.adjustStack(emptyStack);
            this.dropItem(filledStack);
            this.dropItem(partialStack);
        } else if (filledStack.field_77994_a != 0) {
            this.adjustStack(filledStack);
            player.field_71071_by.func_70437_b(filledStack);
            this.dropItem(partialStack);
        } else if (partialStack.field_77994_a != 0) {
            player.field_71071_by.func_70437_b(partialStack);
        } else {
            player.field_71071_by.func_70437_b(null);
            shouldSendStack = false;
        }
        if (shouldSendStack) {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>(), player.field_71071_by.func_70445_o()), (EntityPlayerMP)player);
        } else {
            FluidCraft.proxy.netHandler.sendTo(new SPacketFluidUpdate(new HashMap<Integer, IAEFluidStack>()), (EntityPlayerMP)player);
        }
    }

    void adjustStack(ItemStack stack) {
        if (stack != null && stack.field_77994_a > stack.func_77976_d()) {
            this.dropItem(stack, stack.field_77994_a - stack.func_77976_d());
            stack.field_77994_a = stack.func_77976_d();
        }
    }

    protected boolean isEssentiaMode() {
        return false;
    }

    @Override
    protected boolean isWirelessTerminal() {
        return false;
    }
}

