/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.addons;

import codechicken.wirelessredstone.addons.RedstoneEtherAddons;
import codechicken.wirelessredstone.addons.RemoteTexManager;
import codechicken.wirelessredstone.core.ITileWireless;
import codechicken.wirelessredstone.core.ItemWirelessFreq;
import codechicken.wirelessredstone.core.RedstoneEther;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemWirelessRemote
extends ItemWirelessFreq {
    public ItemWirelessRemote() {
        this.func_77625_d(1);
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && stack.func_77960_j() <= 5000 && stack.func_77960_j() > 0) {
            TileEntity tile = world.func_147438_o(x, y, z);
            int freq = stack.func_77960_j();
            if (tile != null && tile instanceof ITileWireless && RedstoneEther.get(world.field_72995_K).canBroadcastOnFrequency(player, freq)) {
                RedstoneEther.get(world.field_72995_K).setFreq((ITileWireless)tile, freq);
                return true;
            }
        }
        this.func_77659_a(stack, world, player);
        return false;
    }

    @Override
    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer entityplayer) {
        if (entityplayer.func_70093_af()) {
            return super.func_77659_a(stack, world, entityplayer);
        }
        if (!ItemWirelessRemote.getTransmitting(stack) && stack.func_77960_j() != 0) {
            RedstoneEtherAddons.get(world.field_72995_K).activateRemote(world, entityplayer);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean held) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        int freq = this.getItemFreq(stack);
        EntityPlayer player = (EntityPlayer)entity;
        if (!(!ItemWirelessRemote.getTransmitting(stack) || held && RedstoneEtherAddons.get(world.field_72995_K).isRemoteOn(player, freq) || RedstoneEtherAddons.get(world.field_72995_K).deactivateRemote(world, player))) {
            stack.func_77964_b(freq);
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        return !ItemWirelessRemote.getTransmitting(stack);
    }

    @Override
    public int getItemFreq(ItemStack itemstack) {
        return itemstack.func_77960_j() & 0x1FFF;
    }

    public static boolean getTransmitting(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("on", 1) && tag.func_74767_n("on");
    }

    public static void setOn(ItemStack stack, boolean on) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("on", on);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        int freq = stack.func_77960_j();
        if (freq <= 0 || freq > 5000) {
            return RemoteTexManager.getIcon(-1, false);
        }
        return RemoteTexManager.getIcon(RedstoneEther.get(true).getFreqColourId(freq), ItemWirelessRemote.getTransmitting(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack itemstack) {
        return RedstoneEtherAddons.localizeWirelessItem(StatCollector.func_74838_a((String)"wrcbe_addons.remote.short"), itemstack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
    }

    @Override
    public String getGuiName() {
        return StatCollector.func_74838_a((String)"item.wrcbe_addons:remote.name");
    }
}

