/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees.allele.effect;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.HashMap;
import magicbees.bees.AlleleEffect;
import magicbees.bees.BeeManager;
import magicbees.bees.allele.effect.EffectData;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class AlleleEffectCrumbling
extends AlleleEffect {
    private static HashMap<ItemStack, ItemStack> crumbleMap = new HashMap();

    public static void addPairToMap(ItemStack source, ItemStack target) {
        boolean add = true;
        for (ItemStack i : crumbleMap.keySet()) {
            if (!OreDictionary.itemMatches((ItemStack)i, (ItemStack)source, (boolean)false)) continue;
            add = false;
            break;
        }
        if (add) {
            crumbleMap.put(source, target);
        }
    }

    public AlleleEffectCrumbling(String id, boolean isDominant) {
        super(id, isDominant, 600);
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150347_e));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150341_Y));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 2));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack(Blocks.field_150417_aV, 1, 1));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Blocks.field_150463_bK), new ItemStack(Blocks.field_150463_bK, 1, 1));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Blocks.field_150351_n), new ItemStack((Block)Blocks.field_150354_m));
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int zCoord;
        int yCoord;
        World world = housing.getWorld();
        ChunkCoordinates coords = housing.getCoordinates();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int xRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        int yRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[1]);
        int zRange = (int)(beeModifier.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[2]);
        int xCoord = coords.field_71574_a + world.field_73012_v.nextInt(xRange) - xRange / 2;
        Block block = world.func_147439_a(xCoord, yCoord = coords.field_71572_b + world.field_73012_v.nextInt(yRange) - yRange / 2, zCoord = coords.field_71573_c + world.field_73012_v.nextInt(zRange) - zRange / 2);
        if (block != null) {
            ItemStack source = new ItemStack(block, 1, world.func_72805_g(xCoord, yCoord, zCoord));
            for (ItemStack key : crumbleMap.keySet()) {
                if (!OreDictionary.itemMatches((ItemStack)source, (ItemStack)key, (boolean)false)) continue;
                ItemStack target = crumbleMap.get(key);
                world.func_147465_d(xCoord, yCoord, zCoord, Block.func_149634_a((Item)target.func_77973_b()), target.func_77960_j(), 2);
                break;
            }
        }
        storedData.setInteger(0, 0);
        return storedData;
    }
}

