/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thaumcraft.api.internal.WeightedRandomLoot;

@ZenClass(value="mods.thaumcraft.Loot")
public class Loot {
    public static final String name = "Thaumcraft LootBag";

    @ZenMethod
    public static void addCommonLoot(IItemStack stack, int weight) {
        MineTweakerAPI.apply((IUndoableAction)new Add(WeightedRandomLoot.lootBagCommon, new WeightedRandomLoot(InputHelper.toStack(stack), weight)));
    }

    @ZenMethod
    public static void addUncommonLoot(IItemStack stack, int weight) {
        MineTweakerAPI.apply((IUndoableAction)new Add(WeightedRandomLoot.lootBagUncommon, new WeightedRandomLoot(InputHelper.toStack(stack), weight)));
    }

    @ZenMethod
    public static void addRareLoot(IItemStack stack, int weight) {
        MineTweakerAPI.apply((IUndoableAction)new Add(WeightedRandomLoot.lootBagRare, new WeightedRandomLoot(InputHelper.toStack(stack), weight)));
    }

    @ZenMethod
    public static void removeCommonLoot(IIngredient stack) {
        Loot.removeLoot(WeightedRandomLoot.lootBagCommon, stack);
    }

    @ZenMethod
    public static void removeUncommonLoot(IIngredient stack) {
        Loot.removeLoot(WeightedRandomLoot.lootBagUncommon, stack);
    }

    @ZenMethod
    public static void removeRareLoot(IIngredient stack) {
        Loot.removeLoot(WeightedRandomLoot.lootBagRare, stack);
    }

    public static void removeLoot(List<WeightedRandomLoot> list, IIngredient ingredient) {
        LinkedList<WeightedRandomLoot> recipes = new LinkedList<WeightedRandomLoot>();
        for (WeightedRandomLoot loot : list) {
            if (!StackHelper.matches(ingredient, InputHelper.toIItemStack(loot.item))) continue;
            recipes.add(loot);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(list, recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored.", name, ingredient.toString()));
        }
    }

    public static class Remove
    extends BaseListRemoval<WeightedRandomLoot> {
        public Remove(List<WeightedRandomLoot> list, List<WeightedRandomLoot> recipes) {
            super(Loot.name, list, recipes);
        }

        @Override
        protected String getRecipeInfo(WeightedRandomLoot recipe) {
            return LogHelper.getStackDescription(recipe.item);
        }
    }

    public static class Add
    extends BaseListAddition<WeightedRandomLoot> {
        public Add(List<WeightedRandomLoot> list, WeightedRandomLoot recipe) {
            super(Loot.name, list);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(WeightedRandomLoot recipe) {
            return LogHelper.getStackDescription(recipe.item);
        }
    }
}

