/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.world.mapgen;

import de.katzenpapst.amunra.helper.CoordHelper;
import de.katzenpapst.amunra.world.mapgen.BaseStructureStart;
import de.katzenpapst.amunra.world.mapgen.populator.SetSignText;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public abstract class BaseStructureComponent {
    protected int groundLevel = -1;
    protected BaseStructureStart parent = null;
    protected int coordMode = 0;
    protected StructureBoundingBox structBB;

    public int getGroundLevel() {
        return this.groundLevel;
    }

    public void setStructureBoundingBox(StructureBoundingBox structBB) {
        this.structBB = structBB;
    }

    public StructureBoundingBox getStructureBoundingBox() {
        return this.structBB;
    }

    public boolean generateChunk(int chunkX, int chunkZ, Block[] arrayOfIDs, byte[] arrayOfMeta) {
        return true;
    }

    public void setParent(BaseStructureStart parent) {
        this.parent = parent;
    }

    public void setCoordMode(int coordMode) {
        this.coordMode = coordMode;
    }

    protected int translateX(int x, int z) {
        switch (this.coordMode) {
            case 0: 
            case 2: {
                return x;
            }
            case 1: {
                return this.structBB.field_78893_d - (z - this.structBB.field_78896_c);
            }
            case 3: {
                return this.structBB.field_78897_a + z - this.structBB.field_78896_c;
            }
        }
        return x;
    }

    protected int translateZ(int x, int z) {
        int n;
        switch (this.coordMode) {
            case 0: {
                n = z;
                break;
            }
            case 1: 
            case 3: {
                n = this.structBB.field_78896_c + x - this.structBB.field_78897_a;
                break;
            }
            case 2: {
                n = this.structBB.field_78892_f - (z - this.structBB.field_78896_c);
                break;
            }
            default: {
                n = z;
            }
        }
        return n;
    }

    protected int getHighestSolidBlockInBB(Block[] blocks, byte[] metas, int chunkX, int chunkZ, int x, int z) {
        int xOffset = this.getXWithOffset(x, z);
        int zOffset = this.getZWithOffset(x, z);
        int relX = CoordHelper.abs2rel(xOffset, chunkX);
        int relZ = CoordHelper.abs2rel(zOffset, chunkZ);
        if (relX < 0 || relX >= 16 || relZ < 0 || relZ >= 16) {
            return -1;
        }
        return BaseStructureComponent.getHighestSolidBlock(blocks, metas, relX, relZ);
    }

    protected void fillBox(Block[] blocks, byte[] metas, StructureBoundingBox box, Block block, byte meta) {
        for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
            for (int y = box.field_78895_b; y <= box.field_78894_e; ++y) {
                for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                    int chunkX = CoordHelper.blockToChunk(x);
                    int chunkZ = CoordHelper.blockToChunk(z);
                    BaseStructureComponent.placeBlockAbs(blocks, metas, x, y, z, chunkX, chunkZ, block, meta);
                }
            }
        }
    }

    protected void fillBox(Block[] blocks, byte[] metas, StructureBoundingBox box, BlockMetaPair bmp) {
        this.fillBox(blocks, metas, box, bmp.getBlock(), bmp.getMetadata());
    }

    public static StructureBoundingBox intersectBoundingBoxesXZ(StructureBoundingBox box1, StructureBoundingBox box2) {
        StructureBoundingBox result = new StructureBoundingBox();
        result.field_78897_a = Math.max(box1.field_78897_a, box2.field_78897_a);
        result.field_78896_c = Math.max(box1.field_78896_c, box2.field_78896_c);
        result.field_78893_d = Math.min(box1.field_78893_d, box2.field_78893_d);
        result.field_78892_f = Math.min(box1.field_78892_f, box2.field_78892_f);
        if (result.field_78897_a > result.field_78893_d || result.field_78896_c > result.field_78892_f) {
            return null;
        }
        return result;
    }

    public static StructureBoundingBox intersectBoundingBoxes(StructureBoundingBox box1, StructureBoundingBox box2) {
        StructureBoundingBox result = new StructureBoundingBox();
        result.field_78897_a = Math.max(box1.field_78897_a, box2.field_78897_a);
        result.field_78895_b = Math.max(box1.field_78895_b, box2.field_78895_b);
        result.field_78896_c = Math.max(box1.field_78896_c, box2.field_78896_c);
        result.field_78893_d = Math.min(box1.field_78893_d, box2.field_78893_d);
        result.field_78894_e = Math.min(box1.field_78894_e, box2.field_78894_e);
        result.field_78892_f = Math.min(box1.field_78892_f, box2.field_78892_f);
        if (result.field_78897_a > result.field_78893_d || result.field_78895_b > result.field_78894_e || result.field_78896_c > result.field_78892_f) {
            return null;
        }
        return result;
    }

    protected boolean placeBlockRel2BB(Block[] blocks, byte[] metas, int chunkX, int chunkZ, int x, int y, int z, BlockMetaPair block) {
        int xOffset = this.getXWithOffset(x, z);
        int zOffset = this.getZWithOffset(x, z);
        int relX = CoordHelper.abs2rel(xOffset, chunkX);
        int relZ = CoordHelper.abs2rel(zOffset, chunkZ);
        return BaseStructureComponent.placeBlockRel(blocks, metas, relX, y, relZ, block);
    }

    protected BlockMetaPair getBlockRel2BB(Block[] blocks, byte[] metas, int chunkX, int chunkZ, int x, int y, int z) {
        int xOffset = this.getXWithOffset(x, z);
        int zOffset = this.getZWithOffset(x, z);
        int relX = CoordHelper.abs2rel(xOffset, chunkX);
        int relZ = CoordHelper.abs2rel(zOffset, chunkZ);
        return BaseStructureComponent.getBlockRel(blocks, metas, relX, y, relZ);
    }

    protected boolean placeBlockRel2BB(Block[] blocks, byte[] metas, int chunkX, int chunkZ, int x, int y, int z, Block block, int meta) {
        int xOffset = this.getXWithOffset(x, z);
        int zOffset = this.getZWithOffset(x, z);
        int relX = CoordHelper.abs2rel(xOffset, chunkX);
        int relZ = CoordHelper.abs2rel(zOffset, chunkZ);
        if (relX < 0 || relX >= 16 || relZ < 0 || relZ >= 16) {
            return false;
        }
        return BaseStructureComponent.placeBlockRel(blocks, metas, relX, y, relZ, block, meta);
    }

    protected int getXWithOffset(int x, int z) {
        int n;
        switch (this.coordMode) {
            case 0: 
            case 2: {
                n = this.structBB.field_78897_a + x;
                break;
            }
            case 1: {
                n = this.structBB.field_78893_d - z;
                break;
            }
            case 3: {
                n = this.structBB.field_78897_a + z;
                break;
            }
            default: {
                n = x;
            }
        }
        return n;
    }

    protected int getZWithOffset(int x, int z) {
        int n;
        switch (this.coordMode) {
            case 0: {
                n = this.structBB.field_78896_c + z;
                break;
            }
            case 1: 
            case 3: {
                n = this.structBB.field_78896_c + x;
                break;
            }
            case 2: {
                n = this.structBB.field_78892_f - z;
                break;
            }
            default: {
                n = z;
            }
        }
        return n;
    }

    protected void placeStandingSign(Block[] blocks, byte[] metas, int chunkX, int chunkZ, int x, int y, int z, String text) {
        if (this.placeBlockRel2BB(blocks, metas, chunkX, chunkZ, x, y, z, Blocks.field_150472_an, 0)) {
            int xOffset = this.getXWithOffset(x, z);
            int zOffset = this.getZWithOffset(x, z);
            SetSignText sst = new SetSignText(xOffset, y, zOffset, text);
            this.parent.addPopulator(sst);
        }
    }

    public static int rotateDoorlikeMetadata(int unrotated, int coordMode) {
        return BaseStructureComponent.rotateUniversalMetadata(unrotated, coordMode, 1, 3, 2, 0);
    }

    public static int rotateTorchMetadata(int unrotated, int coordMode) {
        return BaseStructureComponent.rotateStairlikeMetadata(unrotated - 1, coordMode) + 1;
    }

    public static int rotateStairlikeMetadata(int unrotated, int coordMode) {
        return BaseStructureComponent.rotateUniversalMetadata(unrotated, coordMode, 3, 2, 0, 1);
    }

    public static int rotateUniversalMetadata(int unrotated, int coordMode, int n, int s, int e, int w) {
        switch (coordMode) {
            case 1: {
                if (unrotated == n) {
                    return e;
                }
                if (unrotated == e) {
                    return s;
                }
                if (unrotated == w) {
                    return n;
                }
                if (unrotated != s) break;
                return w;
            }
            case 2: {
                if (unrotated == n) {
                    return s;
                }
                if (unrotated != s) break;
                return n;
            }
            case 3: {
                if (unrotated == e) {
                    return s;
                }
                if (unrotated == w) {
                    return n;
                }
                if (unrotated == s) {
                    return e;
                }
                if (unrotated != n) break;
                return w;
            }
        }
        return unrotated;
    }

    public static int rotatePistonlikeMetadata(int unrotated, int coordMode) {
        return BaseStructureComponent.rotateStandardMetadata(unrotated - 2, coordMode) + 2;
    }

    public static int rotateStandardMetadata(int unrotated, int coordMode) {
        return BaseStructureComponent.rotateUniversalMetadata(unrotated, coordMode, 0, 1, 3, 2);
    }

    public static int getAverageGroundLevel(Block[] blocks, byte[] metas, StructureBoundingBox totalBB, StructureBoundingBox chunkBB, int minimum) {
        int sum = 0;
        int total = 0;
        int chunkX = CoordHelper.blockToChunk(chunkBB.field_78897_a);
        int chunkZ = CoordHelper.blockToChunk(chunkBB.field_78896_c);
        for (int z = totalBB.field_78896_c; z <= totalBB.field_78892_f; ++z) {
            for (int x = totalBB.field_78897_a; x <= totalBB.field_78893_d; ++x) {
                if (!chunkBB.func_78890_b(x, 64, z)) continue;
                sum += Math.max(BaseStructureComponent.getHighestSolidBlock(blocks, metas, CoordHelper.abs2rel(x, chunkX), CoordHelper.abs2rel(z, chunkZ)), minimum);
                ++total;
            }
        }
        if (total == 0) {
            return -1;
        }
        return sum / total;
    }

    public static int getHighestSolidBlock(Block[] blocks, byte[] metas, int relX, int relZ) {
        for (int y = 255; y >= 0; --y) {
            int index = BaseStructureComponent.getIndex(relX, y, relZ);
            Block curBlock = blocks[index];
            if (curBlock == null || !curBlock.func_149688_o().func_76230_c() || curBlock.func_149688_o() == Material.field_151584_j) continue;
            return y + 1;
        }
        return -1;
    }

    public static int getHighestSpecificBlock(Block[] blocks, byte[] metas, int relX, int relZ, Block block, byte meta) {
        for (int y = 255; y >= 0; --y) {
            int index = BaseStructureComponent.getIndex(relX, y, relZ);
            if (blocks[index] != block || metas[index] != meta) continue;
            return y;
        }
        return -1;
    }

    public static boolean placeBlockRel(Block[] blocks, byte[] metas, int x, int y, int z, Block id, int meta) {
        if (x < 0 || x >= 16 || z < 0 || z >= 16) {
            return false;
        }
        int index = BaseStructureComponent.getIndex(x, y, z);
        blocks[index] = id;
        metas[index] = (byte)meta;
        return true;
    }

    public static boolean placeBlockRel(Block[] blocks, byte[] metas, int x, int y, int z, BlockMetaPair block) {
        if (x < 0 || x >= 16 || z < 0 || z >= 16) {
            return false;
        }
        int index = BaseStructureComponent.getIndex(x, y, z);
        blocks[index] = block.getBlock();
        metas[index] = block.getMetadata();
        return true;
    }

    public static BlockMetaPair getBlockRel(Block[] blocks, byte[] metas, int x, int y, int z) {
        if (x < 0 || x >= 16 || z < 0 || z >= 16) {
            return null;
        }
        int index = BaseStructureComponent.getIndex(x, y, z);
        return new BlockMetaPair(blocks[index], metas[index]);
    }

    public static boolean placeBlockAbs(Block[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, Block id, int meta) {
        return BaseStructureComponent.placeBlockRel(blocks, metas, CoordHelper.abs2rel(x, cx), y, CoordHelper.abs2rel(z, cz), id, meta);
    }

    public static boolean placeBlockAbs(Block[] blocks, byte[] metas, int x, int y, int z, int cx, int cz, BlockMetaPair block) {
        return BaseStructureComponent.placeBlockRel(blocks, metas, CoordHelper.abs2rel(x, cx), y, CoordHelper.abs2rel(z, cz), block);
    }

    public static boolean placeBlockAbs(Block[] blocks, byte[] metas, int x, int y, int z, BlockMetaPair block) {
        return BaseStructureComponent.placeBlockRel(blocks, metas, CoordHelper.abs2rel(x), y, CoordHelper.abs2rel(z), block);
    }

    public static boolean placeBlockAbs(Block[] blocks, byte[] metas, int x, int y, int z, Block id, int meta) {
        return BaseStructureComponent.placeBlockRel(blocks, metas, CoordHelper.abs2rel(x), y, CoordHelper.abs2rel(z), id, meta);
    }

    public static int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    public double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }
}

