/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.network.transfer;

import com.github.lunatrius.schematica.api.ISchematic;

public class SchematicTransfer {
    public final ISchematic schematic;
    public final String name;
    public final int width;
    public final int height;
    public final int length;
    public State state = State.BEGIN_WAIT;
    public int timeout = 0;
    public int retries = 0;
    public int baseX = 0;
    public int baseY = 0;
    public int baseZ = 0;

    public SchematicTransfer(ISchematic schematic, String name) {
        this.schematic = schematic;
        this.name = name;
        this.width = schematic.getWidth();
        this.height = schematic.getHeight();
        this.length = schematic.getLength();
    }

    public boolean confirmChunk(int chunkX, int chunkY, int chunkZ) {
        if (chunkX == this.baseX && chunkY == this.baseY && chunkZ == this.baseZ) {
            this.setState(State.CHUNK_WAIT);
            this.baseX += 16;
            if (this.baseX >= this.width) {
                this.baseX = 0;
                this.baseY += 16;
                if (this.baseY >= this.height) {
                    this.baseY = 0;
                    this.baseZ += 16;
                    if (this.baseZ >= this.length) {
                        this.setState(State.END_WAIT);
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void setState(State state) {
        this.state = state;
        this.timeout = 0;
        this.retries = 0;
    }

    public static enum State {
        BEGIN_WAIT(true),
        BEGIN,
        CHUNK_WAIT(true),
        CHUNK,
        END_WAIT(true),
        END;

        private boolean waiting;

        private State() {
        }

        private State(boolean waiting) {
            this.waiting = waiting;
        }

        public boolean isWaiting() {
            return this.waiting;
        }
    }
}

