/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.gui.load;

import com.github.lunatrius.core.client.gui.GuiScreenBase;
import com.github.lunatrius.schematica.FileFilterSchematic;
import com.github.lunatrius.schematica.Schematica;
import com.github.lunatrius.schematica.client.gui.load.GuiSchematicEntry;
import com.github.lunatrius.schematica.client.gui.load.GuiSchematicLoadSlot;
import com.github.lunatrius.schematica.client.printer.SchematicPrinter;
import com.github.lunatrius.schematica.client.renderer.RendererSchematicGlobal;
import com.github.lunatrius.schematica.client.util.WorldServerName;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.lwjgl.Sys;

public class GuiSchematicLoad
extends GuiScreenBase {
    private static final FileFilterSchematic FILE_FILTER_FOLDER = new FileFilterSchematic(true);
    private static final FileFilterSchematic FILE_FILTER_SCHEMATIC = new FileFilterSchematic(false);
    protected final List<GuiSchematicEntry> schematicFiles = new ArrayList<GuiSchematicEntry>();
    private final String strTitle = I18n.func_135052_a((String)"schematica.gui.title", (Object[])new Object[0]);
    private final String strFolderInfo = I18n.func_135052_a((String)"schematica.gui.folderInfo", (Object[])new Object[0]);
    protected File currentDirectory = ConfigurationHandler.schematicDirectory;
    private GuiSchematicLoadSlot guiSchematicLoadSlot;
    private GuiButton btnOpenDir = null;
    private GuiButton btnDone = null;

    public GuiSchematicLoad(GuiScreen guiScreen) {
        super(guiScreen);
    }

    public void func_73866_w_() {
        int id = 0;
        this.btnOpenDir = new GuiButton(id++, this.field_146294_l / 2 - 154, this.field_146295_m - 36, 150, 20, I18n.func_135052_a((String)"schematica.gui.openFolder", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnOpenDir);
        this.btnDone = new GuiButton(id++, this.field_146294_l / 2 + 4, this.field_146295_m - 36, 150, 20, I18n.func_135052_a((String)"schematica.gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.btnDone);
        this.guiSchematicLoadSlot = new GuiSchematicLoadSlot(this);
        this.reloadSchematics();
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (guiButton.field_146124_l) {
            if (guiButton.field_146127_k == this.btnOpenDir.field_146127_k) {
                boolean retry = false;
                try {
                    Class<?> c = Class.forName("java.awt.Desktop");
                    Object m = c.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    c.getMethod("browse", URI.class).invoke(m, ConfigurationHandler.schematicDirectory.toURI());
                }
                catch (Throwable e) {
                    retry = true;
                }
                if (retry) {
                    Reference.logger.info("Opening via Sys class!");
                    Sys.openURL((String)("file://" + ConfigurationHandler.schematicDirectory.getAbsolutePath()));
                }
            } else if (guiButton.field_146127_k == this.btnDone.field_146127_k) {
                if (Schematica.proxy.isLoadEnabled) {
                    this.loadSchematic();
                }
                this.field_146297_k.func_147108_a(this.parentScreen);
            } else {
                this.guiSchematicLoadSlot.func_148147_a(guiButton);
            }
        }
    }

    public void func_73863_a(int x, int y, float partialTicks) {
        this.guiSchematicLoadSlot.func_148128_a(x, y, partialTicks);
        this.func_73732_a(this.field_146289_q, this.strTitle, this.field_146294_l / 2, 4, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, this.strFolderInfo, this.field_146294_l / 2 - 78, this.field_146295_m - 12, 0x808080);
        super.func_73863_a(x, y, partialTicks);
    }

    public void func_146281_b() {
    }

    protected void changeDirectory(String directory) {
        this.currentDirectory = new File(this.currentDirectory, directory);
        this.reloadSchematics();
    }

    protected void reloadSchematics() {
        String name = null;
        Item item = null;
        this.schematicFiles.clear();
        try {
            if (!this.currentDirectory.getCanonicalPath().equals(ConfigurationHandler.schematicDirectory.getCanonicalPath())) {
                this.schematicFiles.add(new GuiSchematicEntry("..", Items.field_151129_at, 0, true));
            }
        }
        catch (IOException e) {
            Reference.logger.error("Failed to add GuiSchematicEntry!", (Throwable)e);
        }
        File[] filesFolders = this.currentDirectory.listFiles(FILE_FILTER_FOLDER);
        if (filesFolders == null) {
            Reference.logger.error("listFiles returned null (directory: {})!", new Object[]{this.currentDirectory});
        } else {
            for (File file : filesFolders) {
                if (file == null) continue;
                name = file.getName();
                File[] files = file.listFiles();
                item = files == null || files.length == 0 ? Items.field_151133_ar : Items.field_151131_as;
                this.schematicFiles.add(new GuiSchematicEntry(name, item, 0, file.isDirectory()));
            }
        }
        File[] filesSchematics = this.currentDirectory.listFiles(FILE_FILTER_SCHEMATIC);
        if (filesSchematics == null || filesSchematics.length == 0) {
            this.schematicFiles.add(new GuiSchematicEntry(I18n.func_135052_a((String)"schematica.gui.noschematic", (Object[])new Object[0]), Blocks.field_150346_d, 0, false));
        } else {
            for (File file : filesSchematics) {
                name = file.getName();
                this.schematicFiles.add(new GuiSchematicEntry(name, SchematicUtil.getIconFromFile(file), file.isDirectory()));
            }
        }
    }

    private void loadSchematic() {
        int selectedIndex = this.guiSchematicLoadSlot.selectedIndex;
        try {
            SchematicWorld schematic;
            GuiSchematicEntry schematicEntry;
            if (selectedIndex >= 0 && selectedIndex < this.schematicFiles.size() && Schematica.proxy.loadSchematic(null, this.currentDirectory, (schematicEntry = this.schematicFiles.get(selectedIndex)).getName()) && (schematic = ClientProxy.schematic) != null) {
                ImmutableTriple<Boolean, Integer, ImmutableTriple<Integer, Integer, Integer>> schematicCoordinate = ClientProxy.getCoordinates(WorldServerName.worldServerName(this.field_146297_k), schematic.name);
                if (((Boolean)schematicCoordinate.left).booleanValue()) {
                    ClientProxy.moveSchematic(schematic, (Integer)((ImmutableTriple)schematicCoordinate.right).left, (Integer)((ImmutableTriple)schematicCoordinate.right).middle, (Integer)((ImmutableTriple)schematicCoordinate.right).right);
                    for (int i = 0; i < (Integer)schematicCoordinate.middle; ++i) {
                        schematic.rotate();
                    }
                    RendererSchematicGlobal.INSTANCE.createRendererSchematicChunks(schematic);
                    SchematicPrinter.INSTANCE.refresh();
                } else {
                    ClientProxy.moveSchematicToPlayer(schematic);
                }
            }
        }
        catch (Exception e) {
            Reference.logger.error("Failed to load schematic!", (Throwable)e);
        }
    }
}

