/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.registry.GameRegistry;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.model.PedestalTrophyModelHandler;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ItemTrophyModelHandler
extends PedestalTrophyModelHandler {
    public static final String ID = "item";
    public static final String PROPERTY_REGISTRY_NAME = "registryName";
    public static final String PROPERTY_META = "meta";
    public static final String PROPERTY_NBT = "nbt";
    public static final String PROPERTY_Y_OFFSET = "yOffset";
    public static final String PROPERTY_YAW_OFFSET = "yawOffset";
    public static final String PROPERTY_SCALE = "scale";
    private static final Render RENDER = new Render();
    private EntityItem item;
    private double yOffset = Double.NaN;
    private float yawOffset = 0.0f;
    private float scale = Float.NaN;

    public ItemTrophyModelHandler() {
    }

    public ItemTrophyModelHandler(ItemStack item) {
        this.setItem(item);
        this.calculateScaleAndYOffset(item.func_77973_b());
    }

    public ItemTrophyModelHandler(ItemStack item, float yawOffset) {
        this(item);
        this.yawOffset = yawOffset;
    }

    @Override
    public void parse(String id, JsonObject json) throws JsonSyntaxException {
        String registryName = ConfigHandler.getStringProperty(json, PROPERTY_REGISTRY_NAME);
        int meta = ConfigHandler.getIntegerProperty(json, PROPERTY_META, 0);
        if (meta < 0 || meta > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal meta value (" + meta + ")!");
        }
        String nbt = ConfigHandler.getStringProperty(json, PROPERTY_NBT, null);
        ItemStack stack = GameRegistry.makeItemStack((String)registryName, (int)meta, (int)0, (String)nbt);
        if (stack == null) {
            throw new IllegalArgumentException("Could not find item " + registryName + "!");
        }
        this.yOffset = ConfigHandler.getDoubleProperty(json, PROPERTY_Y_OFFSET, this.yOffset);
        this.yawOffset = ConfigHandler.getFloatProperty(json, PROPERTY_YAW_OFFSET, this.yawOffset);
        this.scale = ConfigHandler.getFloatProperty(json, PROPERTY_SCALE, this.scale);
        this.setItem(stack);
        this.calculateScaleAndYOffset(stack.func_77973_b());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(double x, double y, double z, int rotation, @Nullable String name, long time, float partialTickTime) {
        super.render(x, y, z, rotation, name, time, partialTickTime);
        if (RENDER.func_76983_a() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)(y + this.yOffset), (double)z);
        GL11.glRotatef((float)(22.5f * (float)rotation + this.yawOffset), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GL11.glPushAttrib((int)1048575);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        EntityItem entityItem = this.item;
        synchronized (entityItem) {
            this.item.func_70029_a((World)Minecraft.func_71410_x().field_71441_e);
            RENDER.func_76986_a(this.item, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void setItem(ItemStack item) {
        this.item = new EntityItem(null);
        this.item.func_92058_a(item);
        this.item.field_70290_d = 0.0f;
    }

    private void calculateScaleAndYOffset(Item item) {
        if (Float.isNaN(this.scale)) {
            float f = this.scale = item instanceof ItemBlock ? 1.375f : 0.6875f;
        }
        if (Double.isNaN(this.yOffset)) {
            this.yOffset = (double)this.scale * 0.125 - 0.1875;
        }
    }

    private static class Render
    extends RenderItem {
        public Render() {
            this.func_76976_a(RenderManager.field_78727_a);
        }

        public boolean shouldBob() {
            return false;
        }
    }
}

