/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import glowredman.amazingtrophies.ConfigHandler;
import glowredman.amazingtrophies.model.PedestalTrophyModelHandler;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class EntityTrophyModelHandler
extends PedestalTrophyModelHandler {
    public static final String ID = "entity";
    public static final String PROPERTY_ENTITY = "entity";
    public static final String PROPERTY_Y_OFFSET = "yOffset";
    public static final String PROPERTY_YAW_OFFSET = "yawOffset";
    public static final String PROPERTY_SCALE = "scale";
    public static final String PROPERTY_NBT = "nbt";
    private Entity entity;
    private Render render;
    private Consumer<Float> yawHandler;
    private double yOffset = -0.1875;
    private float yawOffset = 180.0f;
    private float scale = 0.34375f;
    private boolean setsBossStatus;

    public EntityTrophyModelHandler() {
    }

    public EntityTrophyModelHandler(Entity entity) {
        this.entity = entity;
        this.render = RenderManager.field_78727_a.func_78713_a(entity);
        this.setsBossStatus = this.entity instanceof IBossDisplayData;
        this.setYawHandler();
    }

    public EntityTrophyModelHandler(Entity entity, float yOffset, float yawOffset, float scale) {
        this(entity);
        this.yOffset = yOffset;
        this.yawOffset = yawOffset;
        this.scale = scale;
    }

    @Override
    public void parse(String id, JsonObject json) throws JsonSyntaxException {
        NBTTagCompound compound;
        JsonElement entityJson = json.get("entity");
        if (entityJson == null) {
            throw new JsonSyntaxException("Required property \"entity\" is missing!");
        }
        Class<? extends Entity> clazz = ConfigHandler.parseEntityClass(entityJson);
        try {
            this.entity = clazz.getConstructor(World.class).newInstance(new Object[]{null});
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not create a new instance of " + clazz.getName() + "!", e);
        }
        this.render = RenderManager.field_78727_a.func_78713_a(this.entity);
        if (this.render == null) {
            throw new NullPointerException("Could not find render object for " + clazz.getName() + "!");
        }
        this.yOffset = ConfigHandler.getDoubleProperty(json, PROPERTY_Y_OFFSET, this.yOffset);
        this.yawOffset = ConfigHandler.getFloatProperty(json, PROPERTY_YAW_OFFSET, this.yawOffset);
        this.scale = ConfigHandler.getFloatProperty(json, PROPERTY_SCALE, this.scale);
        NBTBase nbt = null;
        try {
            nbt = JsonToNBT.func_150315_a((String)ConfigHandler.getStringProperty(json, PROPERTY_NBT, "{}"));
        }
        catch (NBTException e) {
            throw new IllegalArgumentException("Could not parse NBT", e);
        }
        if (nbt instanceof NBTTagCompound && !(compound = (NBTTagCompound)nbt).func_150296_c().isEmpty()) {
            this.entity.func_70020_e(compound);
        }
        this.setsBossStatus = this.entity instanceof IBossDisplayData;
        this.setYawHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(double x, double y, double z, int rotation, @Nullable String name, long time, float partialTickTime) {
        super.render(x, y, z, rotation, name, time, partialTickTime);
        if (this.render.func_76983_a() == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)(y + this.yOffset), (double)z);
        GL11.glScalef((float)this.scale, (float)this.scale, (float)this.scale);
        GL11.glPushAttrib((int)1048575);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glEnable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        float rotationDeg = this.yawOffset - 22.5f * (float)rotation;
        Entity entity = this.entity;
        synchronized (entity) {
            this.yawHandler.accept(Float.valueOf(rotationDeg));
            this.entity.func_70029_a((World)Minecraft.func_71410_x().field_71441_e);
            if (this.setsBossStatus) {
                String bossName = BossStatus.field_82827_c;
                boolean hasColorModifier = BossStatus.field_82825_d;
                float healthScale = BossStatus.field_82828_a;
                int statusBarTime = BossStatus.field_82826_b;
                this.render.func_76986_a(this.entity, 0.0, 0.0, 0.0, rotationDeg, partialTickTime);
                BossStatus.field_82827_c = bossName;
                BossStatus.field_82825_d = hasColorModifier;
                BossStatus.field_82828_a = healthScale;
                BossStatus.field_82826_b = statusBarTime;
            } else {
                this.render.func_76986_a(this.entity, 0.0, 0.0, 0.0, rotationDeg, partialTickTime);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void setYawHandler() {
        this.yawHandler = rotation -> {
            this.entity.field_70177_z = rotation.floatValue();
            this.entity.field_70126_B = rotation.floatValue();
        };
        if (this.entity instanceof EntityLivingBase) {
            this.yawHandler = this.yawHandler.andThen(rotation -> {
                EntityLivingBase living = (EntityLivingBase)this.entity;
                living.field_70761_aq = rotation.floatValue();
                living.field_70760_ar = rotation.floatValue();
                living.field_70759_as = rotation.floatValue();
                living.field_70758_at = rotation.floatValue();
            });
            if (this.entity instanceof EntityDragon) {
                this.yawHandler = this.yawHandler.andThen(rotation -> Arrays.fill((Object[])((EntityDragon)this.entity).field_70979_e, new double[]{(double)rotation.floatValue() - 180.0, 0.0, 0.0}));
            }
        }
    }
}

