/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.condition;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import glowredman.amazingtrophies.api.ConditionHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class JoinWorldConditionHandler
extends ConditionHandler {
    public static final String ID = "dimension.join";
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_PROVIDER = "provider";
    private final Multimap<Integer, String> conditionsID = HashMultimap.create();
    private final Multimap<Class<? extends WorldProvider>, String> conditionsProvider = HashMultimap.create();

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void parse(String id, JsonObject json) {
        JsonElement idJson = json.get(PROPERTY_ID);
        JsonElement providerJson = json.get(PROPERTY_PROVIDER);
        if (idJson != null && !idJson.isJsonNull() && providerJson != null && !providerJson.isJsonNull()) {
            throw new JsonSyntaxException("Condition is overdefined! Properties \"id\" and \"provider\" exclude each other.");
        }
        if (idJson != null && !idJson.isJsonNull()) {
            this.conditionsID.put((Object)idJson.getAsInt(), (Object)id);
            return;
        }
        if (providerJson != null && !providerJson.isJsonNull()) {
            try {
                Class<?> clazz = Class.forName(providerJson.getAsString());
                if (WorldProvider.class.isAssignableFrom(clazz)) {
                    this.conditionsProvider.put(clazz, (Object)id);
                    return;
                }
                throw new IllegalArgumentException("Could not parse condition of \"" + id + "\": provider " + clazz.getName() + " is not a subclass of " + WorldProvider.class.getName() + "!");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not parse condition of \"" + id + "\": provider class could not be found!", e);
            }
        }
        throw new JsonSyntaxException("Condition is missing required property \"id\" or \"provider\"!");
    }

    @Override
    protected boolean isForgeEventHandler() {
        return !this.conditionsID.isEmpty() || !this.conditionsProvider.isEmpty();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.entity;
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        WorldProvider provider = event.world.field_73011_w;
        for (String id : this.conditionsID.get((Object)provider.field_76574_g)) {
            this.getListener().accept(id, player);
        }
        for (String id : this.conditionsProvider.get(provider.getClass())) {
            this.getListener().accept(id, player);
        }
    }
}

