/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.mixinplugin;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import squeek.applecore.mixinplugin.TargetedMod;

public enum Mixins {
    BlockCactusMixin(new Builder().addMixinClasses("minecraft.BlockCactusMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockCakeMixin(new Builder().addMixinClasses("minecraft.BlockCakeMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockCocoaMixin(new Builder().addMixinClasses("minecraft.BlockCocoaMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockCropsMixin(new Builder().addMixinClasses("minecraft.BlockCropsMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockMushroomMixin(new Builder().addMixinClasses("minecraft.BlockMushroomMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockNetherWartMixin(new Builder().addMixinClasses("minecraft.BlockNetherWartMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockReedMixin(new Builder().addMixinClasses("minecraft.BlockReedMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockSaplingMixin(new Builder().addMixinClasses("minecraft.BlockSaplingMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    BlockStemMixin(new Builder().addMixinClasses("minecraft.BlockStemMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    EntityPlayerMixin(new Builder().addMixinClasses("minecraft.EntityPlayerMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    FoodStatsMixin(new Builder().addMixinClasses("minecraft.FoodStatsMixin").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    FoodStatsMixinAccessor(new Builder().addMixinClasses("minecraft.accessors.FoodStatsAccessor").addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    GuiScreenMixin(new Builder().addMixinClasses("minecraft.GuiScreenMixin").setSide(Side.CLIENT).addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    ItemRendererMixin(new Builder().addMixinClasses("minecraft.ItemRendererMixin").setSide(Side.CLIENT).addTargetedMod(TargetedMod.VANILLA).setPhase(Phase.EARLY)),
    GuiDrawMixin(new Builder().addMixinClasses("codechickenlib.GuiDrawMixin").setSide(Side.CLIENT).addTargetedMod(TargetedMod.CODECHICKEN_LIB).setPhase(Phase.EARLY)),
    BlockPamFruitMixin(new Builder().addMixinClasses("harvestcraft.BlockPamFruitMixin").addTargetedMod(TargetedMod.HARVESTCRAFT)),
    BlockPamSaplingMixin(new Builder().addMixinClasses("harvestcraft.BlockPamSaplingMixin").addTargetedMod(TargetedMod.HARVESTCRAFT)),
    BerryBushMixin(new Builder().addMixinClasses("natura.BerryBushMixin").addTargetedMod(TargetedMod.NATURA)),
    NetherBerryBushMixin(new Builder().addMixinClasses("natura.NetherBerryBushMixin").addTargetedMod(TargetedMod.NATURA));

    public final List<String> mixinClasses;
    public final Phase phase;
    private final Side side;
    public final List<TargetedMod> targetedMods;
    public final List<TargetedMod> excludedMods;

    private Mixins(Builder builder) {
        this.mixinClasses = builder.mixinClasses;
        this.side = builder.side;
        this.targetedMods = builder.targetedMods;
        this.excludedMods = builder.excludedMods;
        this.phase = builder.phase;
        if (this.targetedMods.isEmpty()) {
            throw new RuntimeException("No targeted mods specified!");
        }
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    private boolean allModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return false;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && !loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private boolean noModsLoaded(List<TargetedMod> targetedMods, Set<String> loadedCoreMods, Set<String> loadedMods) {
        if (targetedMods.isEmpty()) {
            return true;
        }
        for (TargetedMod target : targetedMods) {
            if (target == TargetedMod.VANILLA) continue;
            if (!loadedCoreMods.isEmpty() && target.coreModClass != null && loadedCoreMods.contains(target.coreModClass)) {
                return false;
            }
            if (loadedMods.isEmpty() || target.modId == null || !loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    public boolean shouldLoad(Set<String> loadedCoreMods, Set<String> loadedMods) {
        return this.shouldLoadSide() && this.allModsLoaded(this.targetedMods, loadedCoreMods, loadedMods) && this.noModsLoaded(this.excludedMods, loadedCoreMods, loadedMods);
    }

    private static class Builder {
        private final List<String> mixinClasses = new ArrayList<String>();
        private Side side = Side.BOTH;
        private Phase phase = Phase.LATE;
        private final List<TargetedMod> targetedMods = new ArrayList<TargetedMod>();
        private final List<TargetedMod> excludedMods = new ArrayList<TargetedMod>();

        public Builder addMixinClasses(String ... mixinClasses) {
            this.mixinClasses.addAll(Arrays.asList(mixinClasses));
            return this;
        }

        public Builder setPhase(Phase phase) {
            this.phase = phase;
            return this;
        }

        public Builder setSide(Side side) {
            this.side = side;
            return this;
        }

        public Builder addTargetedMod(TargetedMod mod) {
            this.targetedMods.add(mod);
            return this;
        }

        public Builder addExcludedMod(TargetedMod mod) {
            this.excludedMods.add(mod);
            return this;
        }
    }

    static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }

    public static enum Phase {
        EARLY,
        LATE;

    }
}

