/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.util.WeightedChoice;
import greymerk.roguelike.util.WeightedRandomizer;
import greymerk.roguelike.worldgen.BlockBase;
import greymerk.roguelike.worldgen.BlockProvider;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IWorldEditor;
import java.util.Random;

public class BlockWeightedRandom
extends BlockBase {
    private WeightedRandomizer<IBlockFactory> blocks = new WeightedRandomizer();

    public BlockWeightedRandom() {
    }

    public BlockWeightedRandom(JsonElement data) {
        this();
        for (JsonElement entry : (JsonArray)data) {
            JsonObject d = entry.getAsJsonObject();
            int weight = d.get("weight").getAsInt();
            IBlockFactory toAdd = BlockProvider.create(d);
            this.addBlock(toAdd, weight);
        }
    }

    public void addBlock(IBlockFactory toAdd, int weight) {
        this.blocks.add(new WeightedChoice<IBlockFactory>(toAdd, weight));
    }

    @Override
    public boolean set(IWorldEditor editor, Random rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        IBlockFactory block = this.blocks.get(rand);
        return block.set(editor, rand, pos, fillAir, replaceSolid);
    }
}

