/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.util.mst;

import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import java.util.Random;

public class Point {
    private Coord position;
    private Coord adjusted;
    private int rank;
    private Point parent;

    public Point(Coord pos, Random rand) {
        this.position = new Coord(pos);
        this.adjusted = new Coord(pos);
        this.adjusted.add(Cardinal.directions[rand.nextInt(Cardinal.directions.length)]);
        this.rank = 0;
        this.parent = this;
    }

    public double distance(Point other) {
        return this.adjusted.distance(other.adjusted);
    }

    public Coord getPosition() {
        return new Coord(this.position);
    }

    public int getRank() {
        return this.rank;
    }

    public void incRank() {
        ++this.rank;
    }

    public void setParent(Point p) {
        this.parent = p;
    }

    public Point getParent() {
        return this.parent;
    }

    public void scaleBy(double multiplier) {
        double x = this.position.getX();
        double y = this.position.getY();
        double z = this.position.getZ();
        x *= multiplier;
        z *= multiplier;
        x = Math.floor(x);
        z = Math.floor(z);
        this.position = new Coord((int)x, (int)y, (int)z);
    }
}

