/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.api;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.api.AuraEffect;
import makeo.gadomancy.api.ClickBehavior;
import makeo.gadomancy.api.golems.AdditionalGolemType;
import makeo.gadomancy.api.golems.cores.AdditionalGolemCore;
import makeo.gadomancy.api.internal.IApiHandler;
import makeo.gadomancy.common.aura.AuraEffectHandler;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.entities.golems.ItemAdditionalGolemPlacer;
import makeo.gadomancy.common.entities.golems.nbt.ExtendedGolemProperties;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.utils.GolemEnumHelper;
import makeo.gadomancy.common.utils.NBTHelper;
import makeo.gadomancy.common.utils.StringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.entities.golems.EntityGolemBase;

public class DefaultApiHandler
implements IApiHandler {
    private static final Logger log = LogManager.getLogger((String)"Gadomancy_API");
    private static Map<String, AdditionalGolemType> additionalGolemTypes = new HashMap<String, AdditionalGolemType>();
    private static Map<String, AdditionalGolemCore> additionalGolemCores = new HashMap<String, AdditionalGolemCore>();

    @Override
    public boolean registerAdditionalGolemType(String name, String modId, AdditionalGolemType newType) {
        String uniqueName = name.toUpperCase();
        if (!additionalGolemTypes.containsKey(uniqueName)) {
            GolemEnumHelper.addGolemType(uniqueName, newType);
            ItemAdditionalGolemPlacer placerItem = new ItemAdditionalGolemPlacer(newType);
            GameRegistry.registerItem((Item)placerItem, (String)("item" + StringHelper.firstToUpper(name.toLowerCase()) + "GolemPlacer"));
            newType.setModId(modId);
            newType.setPlacerItem(placerItem);
            additionalGolemTypes.put(uniqueName, newType);
            return true;
        }
        return false;
    }

    @Override
    public AdditionalGolemType getAdditionalGolemType(String name) {
        return additionalGolemTypes.get(name.toUpperCase());
    }

    @Override
    public List<AdditionalGolemType> getAdditionalGolemTypes() {
        return new ArrayList<AdditionalGolemType>(additionalGolemTypes.values());
    }

    @Override
    public AdditionalGolemCore getAdditionalGolemCore(EntityGolemBase golem) {
        String coreName = golem.func_70096_w().func_75681_e(ModConfig.golemDatawatcherId);
        if (!coreName.isEmpty()) {
            return additionalGolemCores.get(coreName);
        }
        return null;
    }

    @Override
    public AdditionalGolemCore getAdditionalGolemCore(ItemStack placer) {
        NBTTagCompound persistent;
        if (NBTHelper.hasPersistentData(placer) && (persistent = NBTHelper.getPersistentData(placer)).func_74764_b("Core")) {
            return additionalGolemCores.get(persistent.func_74779_i("Core"));
        }
        return null;
    }

    @Override
    public boolean registerAdditionalGolemCore(String name, AdditionalGolemCore core) {
        if (!additionalGolemCores.containsKey(name)) {
            core.setName(name);
            additionalGolemCores.put(name, core);
            return true;
        }
        return false;
    }

    @Override
    public void setAdditionalGolemCore(EntityGolemBase golem, AdditionalGolemCore core) {
        String coreName = core == null ? "" : core.getName();
        golem.setCore(core == null ? (byte)-1 : (byte)core.getBaseCore());
        golem.func_70096_w().func_75692_b(ModConfig.golemDatawatcherId, (Object)coreName);
        if (!golem.field_70170_p.field_72995_K) {
            NBTHelper.getPersistentData((Entity)golem).func_74778_a("Core", coreName);
            ((ExtendedGolemProperties)golem.getExtendedProperties("gadomancy")).updateGolem();
        } else {
            golem.setupGolem();
            golem.setupGolemInventory();
        }
        golem.field_70170_p.func_72960_a((Entity)golem, (byte)7);
    }

    @Override
    public List<AdditionalGolemCore> getAdditionalGolemCores() {
        return new ArrayList<AdditionalGolemCore>(additionalGolemCores.values());
    }

    @Override
    public void registerClawClickBehavior(ClickBehavior clickBehavior) {
        RegisteredBlocks.registerClawClickBehavior(clickBehavior);
    }

    @Override
    public void registerAdditionalAuraEffect(Aspect aspect, AuraEffect effect) {
        if (aspect == null || effect == null) {
            return;
        }
        if (AuraEffectHandler.registeredEffects.containsKey(aspect)) {
            log.warn("AuraEffect for '" + aspect.getTag() + "' is already registered!");
        } else {
            AuraEffectHandler.registeredEffects.put(aspect, effect);
        }
    }
}

