/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.render.ColorUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.PacketModItemFilter;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.ModItemFilter;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ModItemFilterGui
implements IItemFilterGui {
    private static final int MOD_NAME_COLOR = ColorUtil.getRGB((Color)Color.white);
    private final IItemConduit itemConduit;
    private final GuiExternalConnection gui;
    boolean isInput;
    private final ModItemFilter filter;
    private final Rectangle[] inputBounds;
    private final IconButton[] deleteButs;
    private final IconButton whiteListB;
    private final int inputOffsetX;
    private final int tfWidth;
    private final int tfTextureX;
    private final int tfTextureY;

    public ModItemFilterGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        int butLeft;
        this.gui = gui;
        this.itemConduit = itemConduit;
        this.isInput = isInput;
        int x = butLeft = isInput ? 106 : 5;
        int y = 96;
        this.filter = isInput ? (ModItemFilter)itemConduit.getInputFilter(gui.getDir()) : (ModItemFilter)itemConduit.getOutputFilter(gui.getDir());
        this.inputOffsetX = x;
        this.tfWidth = 52;
        this.tfTextureX = 120;
        this.tfTextureY = 214;
        this.inputBounds = new Rectangle[]{new Rectangle(this.inputOffsetX, y, 16, 16), new Rectangle(this.inputOffsetX, y + 18, 16, 16), new Rectangle(this.inputOffsetX, y + 36, 16, 16)};
        this.deleteButs = new IconButton[this.inputBounds.length];
        for (int i = 0; i < this.deleteButs.length; ++i) {
            IconButton but;
            Rectangle r = this.inputBounds[i];
            this.deleteButs[i] = but = new IconButton((IGuiScreen)gui, GuiExternalConnection.nextButtonId(), r.x + 19, r.y, (IWidgetIcon)IconEIO.MINUS);
        }
        this.whiteListB = new IconButton((IGuiScreen)gui, -1, x + 64, y - 25, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.whitelist")});
    }

    @Override
    public void deactivate() {
        for (IconButton but : this.deleteButs) {
            but.detach();
        }
        this.whiteListB.detach();
    }

    @Override
    public void updateButtons() {
        for (IconButton but : this.deleteButs) {
            but.onGuiInit();
        }
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.blacklist")});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.whitelist")});
        }
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        for (int i = 0; i < this.deleteButs.length; ++i) {
            IconButton but = this.deleteButs[i];
            if (but != guiButton) continue;
            this.setMod(i, null);
            return;
        }
        if (guiButton == this.whiteListB) {
            this.toggleBlacklist();
        }
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindGuiTexture();
        for (Rectangle r : this.inputBounds) {
            this.gui.func_73729_b(this.gui.getGuiLeft() + r.x - 1, this.gui.getGuiTop() + r.y - 1, 24, 214, 18, 18);
            this.gui.func_73729_b(this.gui.getGuiLeft() + r.x + 38, this.gui.getGuiTop() + r.y - 1, this.tfTextureX, this.tfTextureY, this.tfWidth, 18);
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < this.inputBounds.length; ++i) {
            Rectangle r;
            String mod = this.filter.getModAt(i);
            if (mod == null) continue;
            r = this.inputBounds[i];
            mod = fr.func_78269_a(mod, this.tfWidth - 6);
            fr.func_78261_a(mod, this.gui.getGuiLeft() + r.x + 41, this.gui.getGuiTop() + r.y + 4, MOD_NAME_COLOR);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        ItemStack st = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (st == null) {
            return;
        }
        for (int i = 0; i < this.inputBounds.length; ++i) {
            Rectangle bound = this.inputBounds[i];
            if (!bound.contains(x, y)) continue;
            this.setMod(i, st);
        }
    }

    private void setMod(int i, ItemStack st) {
        String mod = this.filter.setMod(i, st);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketModItemFilter(this.itemConduit, this.gui.getDir(), this.isInput, i, mod));
    }

    private void toggleBlacklist() {
        this.filter.setBlacklist(!this.filter.isBlacklist());
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketModItemFilter(this.itemConduit, this.gui.getDir(), this.isInput, -1, this.filter.isBlacklist() ? "1" : "0"));
    }
}

