/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.enderio.core.common.util.BlockCoord;
import java.util.List;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.plugins.PluginBase;

@Plugin(name="IFluidHandler")
public class PluginIFluidHandler
extends PluginBase {
    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.registerBody(IFluidHandler.class);
        this.registerNBT(IFluidHandler.class);
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        FluidTankInfo[] infos = PluginIFluidHandler.readFluidInfosFromNBT(accessor.getNBTData());
        PluginIFluidHandler.addTankTooltip(currenttip, infos);
    }

    public static void addTankTooltip(List<String> currenttip, FluidTankInfo ... tanks) {
        for (FluidTankInfo tank : tanks) {
            if (tank == null || tank.fluid == null) continue;
            ((ITaggedList)currenttip).add((Object)(tank.fluid.amount + " / " + tank.capacity + " mB " + tank.fluid.getLocalizedName()), (Object)"IFluidHandler");
        }
    }

    @Override
    protected void getNBTData(TileEntity te, NBTTagCompound tag, World world, BlockCoord pos) {
        PluginIFluidHandler.writeFluidInfoToNBT((IFluidHandler)te, tag);
    }

    public static void writeFluidInfoToNBT(IFluidHandler te, NBTTagCompound tag) {
        FluidTankInfo[] infos = te.getTankInfo(ForgeDirection.UNKNOWN);
        if (infos != null && infos.length > 0) {
            NBTTagList infoList = new NBTTagList();
            for (FluidTankInfo info : infos) {
                NBTTagCompound infoTag = new NBTTagCompound();
                PluginIFluidHandler.writeFluidInfoToNBT(info, infoTag);
                infoList.func_74742_a((NBTBase)infoTag);
            }
            tag.func_74782_a("fluidInfo", (NBTBase)infoList);
        }
    }

    public static FluidTankInfo[] readFluidInfosFromNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("fluidInfo", 10);
        FluidTankInfo[] ret = new FluidTankInfo[list.func_74745_c()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = PluginIFluidHandler.readFluidInfoFromNBT(list.func_150305_b(i));
        }
        return ret;
    }

    public static void writeFluidInfoToNBT(FluidTankInfo info, NBTTagCompound tag) {
        if (info.fluid != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            info.fluid.writeToNBT(fluidTag);
            tag.func_74782_a("fluid", (NBTBase)fluidTag);
        }
        tag.func_74768_a("capacity", info.capacity);
    }

    public static FluidTankInfo readFluidInfoFromNBT(NBTTagCompound tag) {
        FluidStack fluid = tag.func_74764_b("fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("fluid")) : null;
        int capacity = tag.func_74762_e("capacity");
        return new FluidTankInfo(fluid, capacity);
    }
}

