/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.utils;

import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public final class VPByteBufUtils {
    public static void WriteOreVeinPosition(ByteBuf buf, OreVeinPosition oreVeinPosition) {
        buf.writeInt(oreVeinPosition.dimensionId);
        buf.writeInt(oreVeinPosition.chunkX);
        buf.writeInt(oreVeinPosition.chunkZ);
        buf.writeShort((int)oreVeinPosition.veinType.veinId);
        buf.writeBoolean(oreVeinPosition.isDepleted());
    }

    public static OreVeinPosition ReadOreVeinPosition(ByteBuf buf) {
        int dimId = buf.readInt();
        int chunkX = buf.readInt();
        int chunkZ = buf.readInt();
        short veinId = buf.readShort();
        boolean isDepleted = buf.readBoolean();
        return new OreVeinPosition(dimId, chunkX, chunkZ, VeinTypeCaching.getVeinType(veinId), isDepleted);
    }

    public static void WriteUndergroundFluidPosition(ByteBuf buf, UndergroundFluidPosition undergroundFluidPosition) {
        buf.writeInt(undergroundFluidPosition.dimensionId);
        buf.writeInt(undergroundFluidPosition.chunkX);
        buf.writeInt(undergroundFluidPosition.chunkZ);
        buf.writeInt(undergroundFluidPosition.fluid.getID());
        for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
            for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                buf.writeInt(undergroundFluidPosition.chunks[offsetChunkX][offsetChunkZ]);
            }
        }
    }

    public static UndergroundFluidPosition ReadUndergroundFluidPosition(ByteBuf buf) {
        int dimId = buf.readInt();
        int chunkX = buf.readInt();
        int chunkZ = buf.readInt();
        Fluid fluid = FluidRegistry.getFluid((int)buf.readInt());
        int[][] chunks = new int[8][8];
        for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
            for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                chunks[offsetChunkX][offsetChunkZ] = buf.readInt();
            }
        }
        return new UndergroundFluidPosition(dimId, chunkX, chunkZ, fluid, chunks);
    }

    public static void WriteOreVeinPositions(ByteBuf buf, List<OreVeinPosition> oreVeinPositions) {
        buf.writeInt(oreVeinPositions.size());
        for (OreVeinPosition oreVeinPosition : oreVeinPositions) {
            VPByteBufUtils.WriteOreVeinPosition(buf, oreVeinPosition);
        }
    }

    public static List<OreVeinPosition> ReadOreVeinPositions(ByteBuf buf) {
        ArrayList<OreVeinPosition> oreVeinPositions = new ArrayList<OreVeinPosition>();
        int oreVeinCount = buf.readInt();
        for (int i = 0; i < oreVeinCount; ++i) {
            oreVeinPositions.add(VPByteBufUtils.ReadOreVeinPosition(buf));
        }
        return oreVeinPositions;
    }

    public static void WriteUndergroundFluidPositions(ByteBuf buf, List<UndergroundFluidPosition> undergroundFluidPositions) {
        buf.writeInt(undergroundFluidPositions.size());
        for (UndergroundFluidPosition undergroundFluidPosition : undergroundFluidPositions) {
            VPByteBufUtils.WriteUndergroundFluidPosition(buf, undergroundFluidPosition);
        }
    }

    public static List<UndergroundFluidPosition> ReadUndergroundFluidPositions(ByteBuf buf) {
        ArrayList<UndergroundFluidPosition> undergroundFluidPositions = new ArrayList<UndergroundFluidPosition>();
        int undergroundFluidCount = buf.readInt();
        for (int i = 0; i < undergroundFluidCount; ++i) {
            undergroundFluidPositions.add(VPByteBufUtils.ReadUndergroundFluidPosition(buf));
        }
        return undergroundFluidPositions;
    }
}

