/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.locations;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.integration.model.locations.ILocationProvider;
import net.minecraftforge.fluids.Fluid;

public class UndergroundFluidChunkLocation
implements ILocationProvider {
    private final int blockX;
    private final int blockZ;
    private final int dimensionId;
    private final Fluid fluid;
    private final int fluidAmount;
    private final int maxAmountInField;
    private final int minAmountInField;

    public UndergroundFluidChunkLocation(int chunkX, int chunkZ, int dimensionId, Fluid fluid, int fluidAmount, int minAmountInField, int maxAmountInField) {
        this.blockX = Utils.coordChunkToBlock(chunkX);
        this.blockZ = Utils.coordChunkToBlock(chunkZ);
        this.dimensionId = dimensionId;
        this.fluid = fluid;
        this.fluidAmount = fluidAmount;
        this.maxAmountInField = maxAmountInField;
        this.minAmountInField = minAmountInField;
    }

    @Override
    public double getBlockX() {
        return (double)this.blockX + 0.5;
    }

    @Override
    public double getBlockZ() {
        return (double)this.blockZ + 0.5;
    }

    @Override
    public int getDimensionId() {
        return this.dimensionId;
    }

    public String getFluidAmountFormatted() {
        if (this.fluidAmount >= 1000) {
            return this.fluidAmount / 1000 + "kL";
        }
        return this.fluidAmount + "L";
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getMaxAmountInField() {
        return this.maxAmountInField;
    }

    public int getMinAmountInField() {
        return this.minAmountInField;
    }
}

