/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.locations;

import com.dyonovan.tcnodetracker.lib.NodeList;
import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.integration.model.locations.IWaypointAndLocationProvider;
import com.sinthoras.visualprospecting.integration.model.waypoints.Waypoint;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileNode;

public class ThaumcraftNodeLocation
implements IWaypointAndLocationProvider {
    private static final String deleteHint = EnumChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"visualprospecting.node.deletehint", (Object[])new Object[]{Keyboard.getKeyName((int)VP.keyAction.func_151463_i())});
    private static final String activeWaypointHint = EnumChatFormatting.GOLD + I18n.func_135052_a((String)"visualprospecting.iswaypoint", (Object[])new Object[0]);
    private static final String title = EnumChatFormatting.BOLD + I18n.func_135052_a((String)"tile.blockAiry.0.name", (Object[])new Object[0]);
    private final NodeList node;
    private final TileNode nodeTile;
    private final String description;
    private boolean isActiveAsWaypoint;

    public ThaumcraftNodeLocation(NodeList node) {
        this.node = node;
        this.nodeTile = new TileNode();
        AspectList aspectList = new AspectList();
        for (String aspectTag : node.aspect.keySet()) {
            aspectList.add(Aspect.getAspect((String)aspectTag), ((Integer)node.aspect.get(aspectTag)).intValue());
        }
        this.nodeTile.setAspects(aspectList);
        switch (node.type) {
            case "NORMAL": {
                this.nodeTile.setNodeType(NodeType.NORMAL);
                break;
            }
            case "UNSTABLE": {
                this.nodeTile.setNodeType(NodeType.UNSTABLE);
                break;
            }
            case "DARK": {
                this.nodeTile.setNodeType(NodeType.DARK);
                break;
            }
            case "TAINTED": {
                this.nodeTile.setNodeType(NodeType.TAINTED);
                break;
            }
            case "PURE": {
                this.nodeTile.setNodeType(NodeType.PURE);
                break;
            }
            case "HUNGRY": {
                this.nodeTile.setNodeType(NodeType.HUNGRY);
            }
        }
        this.nodeTile.field_145854_h = ConfigBlocks.blockAiry;
        this.nodeTile.field_145847_g = 0;
        this.description = node.mod.equals("BLANK") ? EnumChatFormatting.GRAY + I18n.func_135052_a((String)("nodetype." + node.type + ".name"), (Object[])new Object[0]) : EnumChatFormatting.GRAY + I18n.func_135052_a((String)("nodetype." + node.type + ".name"), (Object[])new Object[0]) + ", " + I18n.func_135052_a((String)("nodemod." + node.mod + ".name"), (Object[])new Object[0]);
    }

    @Override
    public double getBlockX() {
        return (double)this.node.x + 0.5;
    }

    public double getBlockY() {
        return (double)this.node.y + 0.5;
    }

    @Override
    public double getBlockZ() {
        return (double)this.node.z + 0.5;
    }

    @Override
    public int getDimensionId() {
        return this.node.dim;
    }

    @Override
    public Waypoint toWaypoint() {
        return new Waypoint(this.node.x, this.node.y, this.node.z, this.node.dim, I18n.func_135052_a((String)"visualprospecting.tracked", (Object[])new Object[]{I18n.func_135052_a((String)"tile.blockAiry.0.name", (Object[])new Object[0])}), this.nodeTile.targetColor.getRGB());
    }

    @Override
    public boolean isActiveAsWaypoint() {
        return this.isActiveAsWaypoint;
    }

    @Override
    public void onWaypointCleared() {
        this.isActiveAsWaypoint = false;
    }

    @Override
    public void onWaypointUpdated(Waypoint waypoint) {
        this.isActiveAsWaypoint = waypoint.dimensionId == this.node.dim && waypoint.blockX == this.node.x && waypoint.blockY == this.node.y && waypoint.blockZ == this.node.z;
    }

    public boolean belongsToNode(NodeList other) {
        return this.node.x == other.x && this.node.y == other.y && this.node.z == other.z && this.node.dim == other.dim;
    }

    public Aspect getStrongestAspect() {
        return this.nodeTile.getAspects().getAspectsSortedAmount()[0];
    }

    public AspectList getAspects() {
        return this.nodeTile.getAspects();
    }

    public String getDescription() {
        return this.description;
    }

    public String getDeleteHint() {
        return deleteHint;
    }

    public String getActiveWaypointHint() {
        return activeWaypointHint;
    }

    public String getTitle() {
        return title;
    }
}

