/*
 * Decompiled with CFR 0.152.
 */
package thaumicboots.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ic2.api.item.ElectricItem;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import thaumicboots.api.IMeteor;
import thaumicboots.api.ISpecialEffect;
import thaumicboots.api.ItemBoots;
import thaumicboots.api.ItemElectricBoots;
import thaumicboots.item.boots.comet.ItemElectricCometBoots;
import thaumicboots.item.boots.meteor.ItemElectricMeteorBoots;
import thaumicboots.main.Config;
import thaumicboots.main.utils.compat.EMTHelper;

public class BootsEventHandler {
    public static final PlayerCapabilities genericPlayerCapabilities = new PlayerCapabilities();
    HashMap<Integer, Float> prevStep = new HashMap();

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        this.checkAir(player);
        if (!event.entity.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack boots = player.field_71071_by.func_70440_f(0);
        if (this.prevStep.containsKey(event.entity.func_145782_y()) && (boots == null || !(boots.func_77973_b() instanceof ItemElectricMeteorBoots) && !(boots.func_77973_b() instanceof ItemElectricCometBoots))) {
            event.entity.field_70138_W = this.prevStep.get(event.entity.func_145782_y()).floatValue();
            this.prevStep.remove(event.entity.func_145782_y());
        }
    }

    @SubscribeEvent
    public void joinWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)event.entity;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        if (player.field_71071_by.func_70440_f(0) == null) {
            return;
        }
        Item item = player.field_71071_by.func_70440_f(0).func_77973_b();
        if (EMTHelper.isActive() && item instanceof ItemElectricBoots && ElectricItem.manager.getCharge(player.field_71071_by.func_70440_f(0)) == 0.0) {
            return;
        }
        if (item instanceof IMeteor) {
            IMeteor meteor = (IMeteor)item;
            if (player.func_70093_af()) {
                meteor.specialEffect2(event);
                return;
            }
        }
        if (!(item instanceof ItemBoots)) return;
        ItemBoots boots = (ItemBoots)item;
        event.entityLiving.field_70181_x += boots.getJumpModifier() * ItemBoots.isJumpEnabled(player.field_71071_by.func_70440_f(0));
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        double energyDemand;
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entity = (EntityPlayer)event.entity;
        if (entity.field_71071_by.field_70460_b[0] == null) {
            return;
        }
        ItemStack itemStack = entity.field_71071_by.field_70460_b[0];
        Item item = itemStack.func_77973_b();
        if (!Config.emtActive || !(item instanceof ItemElectricCometBoots)) {
            return;
        }
        ItemElectricCometBoots bootItem = (ItemElectricCometBoots)item;
        if (event.distance <= bootItem.getMinimumHeight()) {
            event.setCanceled(true);
            return;
        }
        if (EMTHelper.isActive() && (energyDemand = (double)bootItem.getPowerConsumption(event.distance)) <= ElectricItem.manager.getCharge(itemStack)) {
            ElectricItem.manager.discharge(itemStack, energyDemand, Integer.MAX_VALUE, true, false, false);
            event.setCanceled(true);
        }
    }

    public void checkAir(EntityPlayer player) {
        if (player.field_71071_by.func_70440_f(0) == null) {
            return;
        }
        Item item = player.field_71071_by.func_70440_f(0).func_77973_b();
        if (item instanceof ISpecialEffect) {
            ISpecialEffect boot = (ISpecialEffect)item;
            boot.specialEffect(item, player);
        }
    }
}

