/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.slime;

import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialSlime
extends EntitySlime
implements ISpecialMob {
    private static final boolean TINY_SLIME_DAMAGE = Properties.getBoolean("_mob_stats", "tiny_slime_damage");
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/slime/slime.png")};
    private SpecialMobData specialData;
    public int field_70810_d;

    public Entity_SpecialSlime(World world) {
        super(world);
    }

    protected float getSizeMultiplier() {
        return 0.6f;
    }

    protected int getTypeXp() {
        return 0;
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        this.adjustTypeAttributes();
    }

    protected void adjustTypeAttributes() {
    }

    protected void adjustHealthAttribute() {
    }

    protected void func_70799_a(int size) {
        super.func_70799_a(size);
        this.func_70105_a((float)size * this.getSizeMultiplier(), (float)size * this.getSizeMultiplier());
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.adjustHealthAttribute();
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV += this.getTypeXp();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        EntitySlime proxy = new EntitySlime(this.field_70170_p);
        proxy.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)proxy);
    }

    protected void func_70626_be() {
        this.func_70623_bb();
        EntityPlayer target = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (target != null) {
            this.func_70625_a((Entity)target, 10.0f, 20.0f);
        }
        this.attackEntityByType(target);
        if (this.field_70122_E && this.field_70810_d-- <= 0) {
            this.field_70810_d = this.func_70806_k();
            if (this.jumpByType(target)) {
                this.field_70703_bu = true;
                if (this.func_70807_r()) {
                    this.func_85030_a(this.func_70803_o(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                }
            }
        } else {
            this.field_70703_bu = false;
            if (this.field_70122_E) {
                this.field_70701_bs = 0.0f;
                this.field_70702_br = 0.0f;
            }
        }
    }

    protected void attackEntityByType(EntityPlayer target) {
    }

    protected boolean jumpByType(EntityPlayer target) {
        if (target != null) {
            this.field_70810_d /= 3;
        }
        this.field_70702_br = 1.0f - this.field_70146_Z.nextFloat() * 2.0f;
        this.field_70701_bs = this.func_70809_q();
        return true;
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.field_70724_aR <= 0 && this.func_70800_m() && this.func_70685_l((Entity)player) && this.func_70068_e((Entity)player) < (double)(this.field_70130_N * this.field_70130_N + player.field_70130_N * player.field_70130_N * 1.3f) && this.func_70652_k((Entity)player)) {
            this.field_70724_aR = 20;
            this.func_85030_a("mob.slime.attack", 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected boolean func_70800_m() {
        return TINY_SLIME_DAMAGE || this.func_70809_q() > 1;
    }

    public boolean func_70652_k(Entity target) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + (float)this.func_70805_n();
        int knockback = 0;
        if (target instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_77512_a((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
            knockback += EnchantmentHelper.func_77507_b((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)target));
        }
        if (target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage)) {
            int fireAspect;
            if (knockback > 0) {
                target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspect = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireAspect * 4);
            }
            if (target instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)target);
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
    }

    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
    }

    protected Entity_SpecialSlime createInstance() {
        try {
            return (Entity_SpecialSlime)this.getClass().getConstructor(World.class).newInstance(this.field_70170_p);
        }
        catch (Exception ex) {
            _SpecialMobs.debugException("Error splitting slime! " + ex.getClass().getName() + " @" + this.getClass().getName());
            return new Entity_SpecialSlime(this.field_70170_p);
        }
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    protected void func_70069_a(float distance) {
        if (!this.getSpecialData().isImmuneToFalling) {
            super.func_70069_a(distance);
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }
}

