/*
 * Decompiled with CFR 0.152.
 */
package se.rupy.http;

import java.io.IOException;
import java.util.HashMap;
import se.rupy.http.Event;
import se.rupy.http.Output;

public class Reply {
    public static int OK = 0;
    public static int COMPLETE = 1;
    public static int PROCESSING = 2;
    private String type = "text/html; charset=UTF-8";
    private HashMap headers;
    protected Output output;
    private Event event;
    private long modified;
    private String code;

    protected Reply(Event event) throws IOException {
        this.event = event;
        this.output = new Output.Chunked(this);
        this.reset();
    }

    protected void done() throws IOException {
        this.event.log("done " + this.output.push(), Event.DEBUG);
        if (!this.output.push()) {
            this.output.end();
            if (this.headers != null) {
                this.headers.clear();
            }
            this.reset();
        }
    }

    protected void reset() {
        this.modified = 0L;
        this.type = "text/html; charset=UTF-8";
        this.code = "200 OK";
    }

    protected Event event() {
        return this.event;
    }

    protected HashMap headers() {
        return this.headers;
    }

    public String code() {
        return this.code;
    }

    protected int length() {
        return this.output.length();
    }

    protected boolean push() {
        return this.output.push();
    }

    public void code(String code) throws IOException {
        this.event.log("code", Event.DEBUG);
        this.code = code;
        this.output.init(0L);
    }

    public String type() {
        return this.type;
    }

    public void type(String type) {
        this.type = type;
    }

    public void header(String name, String value) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(name, value);
    }

    protected long modified() {
        return this.modified;
    }

    protected void modified(long modified) {
        this.modified = modified;
    }

    public Output output() throws IOException {
        return this.output(0L);
    }

    public Output output(long length) throws IOException {
        this.event.log("output " + length, Event.DEBUG);
        this.output.init(length);
        return this.output;
    }

    public int wakeup() {
        if (this.output.complete()) {
            return COMPLETE;
        }
        if (this.event.worker() != null) {
            return PROCESSING;
        }
        this.event.daemon().employ(this.event);
        return OK;
    }
}

