/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.lib.utils.StringUtils;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class PatternParameterCenter
implements IStatementParameter {
    private static final int[] shiftLeft = new int[]{6, 3, 0, 7, 4, 1, 8, 5, 2};
    private static IIcon[] icons;
    private int direction;

    public PatternParameterCenter() {
    }

    public PatternParameterCenter(int direction) {
        this();
        this.direction = direction;
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:fillerParameterCenter";
    }

    @Override
    public IIcon getIcon() {
        return icons[this.direction % 9];
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        icons = new IIcon[9];
        for (int i = 0; i < 9; ++i) {
            PatternParameterCenter.icons[i] = iconRegister.func_94245_a("buildcraftcore:fillerParameters/center_" + i);
        }
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("direction.center." + this.direction);
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        this.direction = (this.direction + 1) % 9;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.direction = compound.func_74771_c("dir");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("dir", (byte)this.direction);
    }

    @Override
    public IStatementParameter rotateLeft() {
        return new PatternParameterCenter(shiftLeft[this.direction % 9]);
    }

    public int getDirection() {
        return this.direction;
    }
}

