/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import com.google.common.collect.MapMaker;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import openblocks.OpenBlocks;
import openblocks.common.entity.EntityHangGlider;
import openmods.infobook.BookDocumentation;

@BookDocumentation(hasVideo=true)
public class ItemHangGlider
extends Item {
    private static final Map<EntityPlayer, EntityHangGlider> spawnedGlidersMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static HashSet<Integer> blacklistedDimensions = new HashSet();

    public ItemHangGlider() {
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
    }

    public static void loadConfig(FMLPreInitializationEvent event) {
        int[] dimensionIDs;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        for (int id : dimensionIDs = config.get("general", "BlacklistedDimensions", new int[]{95, 94, 93, 92, 86, 85, 84, 83, 82, 81, 77, 74, 71, 69, 63, 54, 51, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 33, 32, 31, 30, 29, 28, 25}, "List of dimension IDs where the glider doesn't work").getIntList()) {
            blacklistedDimensions.add(id);
        }
        config.save();
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (!world.field_72995_K && player != null) {
            EntityHangGlider glider = spawnedGlidersMap.get(player);
            if (glider != null) {
                ItemHangGlider.despawnGlider(player, glider);
            } else {
                ItemHangGlider.spawnGlider(player);
            }
        }
        return itemStack;
    }

    private static void despawnGlider(EntityPlayer player, EntityHangGlider glider) {
        glider.func_70106_y();
        spawnedGlidersMap.remove(player);
    }

    private static void spawnGlider(EntityPlayer player) {
        if (ItemHangGlider.isInvalidDimension(player)) {
            player.func_145747_a((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"item.openblocks.hangglider.invalid_dimension", (Object[])new Object[0])));
            return;
        }
        EntityHangGlider glider = new EntityHangGlider(player.field_70170_p, player);
        glider.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70125_A, player.field_70177_z);
        player.field_70170_p.func_72838_d((Entity)glider);
        spawnedGlidersMap.put(player, glider);
    }

    private static boolean isInvalidDimension(EntityPlayer player) {
        return blacklistedDimensions.contains(player.field_71093_bK);
    }
}

