/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.gui.events;

import mcp.mobius.opis.gui.interfaces.IWidget;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

public class MouseEvent {
    public long timestamp;
    public Minecraft mc;
    public IWidget srcwidget;
    public IWidget trgwidget;
    public double x;
    public double y;
    public int z;
    public static int buttonCount = Mouse.getButtonCount();
    public boolean[] buttonState = new boolean[buttonCount];
    public EventType type;
    public int button = -1;

    public MouseEvent(IWidget widget) {
        this.srcwidget = widget;
        this.timestamp = System.nanoTime();
        this.mc = Minecraft.func_71410_x();
        this.x = (double)Mouse.getEventX() * (double)this.srcwidget.getSize().getX() / (double)this.mc.field_71443_c;
        this.y = (double)this.srcwidget.getSize().getY() - (double)Mouse.getEventY() * (double)this.srcwidget.getSize().getY() / (double)this.mc.field_71440_d - 1.0;
        this.z = Mouse.getDWheel();
        for (int i = 0; i < buttonCount; ++i) {
            this.buttonState[i] = Mouse.isButtonDown((int)i);
        }
        this.trgwidget = this.srcwidget.getWidgetAtCoordinates(this.x, this.y);
    }

    public String toString() {
        String retstring = String.format("MOUSE %s :  [%s] [ %.2f %.2f %d ] [", new Object[]{this.type, this.timestamp, this.x, this.y, this.z});
        if (buttonCount < 5) {
            int i = 0;
            while (true) {
                if (i < buttonCount) {
                    retstring = retstring + String.format(" %s ", this.buttonState[i]);
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                retstring = retstring + String.format(" %s ", this.buttonState[i]);
            }
        }
        retstring = retstring + "]";
        if (this.button != -1) {
            retstring = retstring + String.format(" Button %s", this.button);
        }
        return retstring;
    }

    public EventType getEventType(MouseEvent me) {
        this.type = EventType.NONE;
        if (this.trgwidget != me.trgwidget) {
            this.type = EventType.ENTER;
            return this.type;
        }
        if (this.z != 0) {
            this.type = EventType.WHEEL;
            return this.type;
        }
        int i = 0;
        while (true) {
            if (i >= buttonCount) break;
            if (this.buttonState[i] != me.buttonState[i]) {
                this.type = this.buttonState[i] ? EventType.CLICK : EventType.RELEASED;
                this.button = i;
                return this.type;
            }
            ++i;
        }
        if (this.x != me.x || this.y != me.y) {
            this.type = this.buttonState[0] ? EventType.DRAG : EventType.MOVE;
            return this.type;
        }
        return this.type;
    }

    public static enum EventType {
        NONE,
        MOVE,
        CLICK,
        RELEASED,
        DRAG,
        WHEEL,
        ENTER,
        LEAVE;

    }
}

