/*
 * Decompiled with CFR 0.152.
 */
package taintedmagic.common.items.wand.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import taintedmagic.common.TaintedMagic;
import taintedmagic.common.entities.EntityHomingShard;
import taintedmagic.common.handler.ConfigHandler;
import taintedmagic.common.helper.TaintedMagicHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemFocusVisShard
extends ItemFocusBasic {
    private static final AspectList costBase = new AspectList().add(Aspect.FIRE, 120).add(Aspect.ENTROPY, 120).add(Aspect.AIR, 120);
    private static final AspectList costPersistant = new AspectList().add(Aspect.WATER, 120);
    public static FocusUpgradeType persistant = new FocusUpgradeType(69, new ResourceLocation("taintedmagic:textures/foci/IconPersistant.png"), "focus.upgrade.persistant.name", "focus.upgrade.persistant.text", new AspectList().add(Aspect.ARMOR, 1).add(Aspect.MOTION, 1).add(Aspect.ENERGY, 1));

    public ItemFocusVisShard() {
        this.func_77637_a(TaintedMagic.tabTaintedMagic);
        this.func_77655_b("ItemFocusVisShard");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("taintedmagic:ItemFocusVisShard");
    }

    public String getSortingHelper(ItemStack stack) {
        return "SHARD" + super.getSortingHelper(stack);
    }

    public int getFocusColor(ItemStack stack) {
        return 10037693;
    }

    public int getActivationCooldown(ItemStack stack) {
        return 500;
    }

    public ItemFocusBasic.WandFocusAnimation getAnimation(ItemStack stack) {
        return ItemFocusBasic.WandFocusAnimation.WAVE;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        Entity look = EntityUtils.getPointedEntity((World)player.field_70170_p, (Entity)player, (double)0.0, (double)32.0, (float)1.1f);
        if (look instanceof EntityLivingBase && wand.consumeAllVis(stack, player, this.getVisCost(stack), true, false)) {
            if (!world.field_72995_K) {
                EntityHomingShard blast = new EntityHomingShard(world, (EntityLivingBase)player, (EntityLivingBase)look, (int)TaintedMagicHelper.getFocusDamageWithPotency(stack, ConfigHandler.visShardBaseDamage, ConfigHandler.visShardStaffMultiple), this.isUpgradedWith(wand.getFocusItem(stack), persistant));
                world.func_72838_d((Entity)blast);
                world.func_72956_a((Entity)blast, "taintedmagic:shard", 0.3f, 1.1f + world.field_73012_v.nextFloat() * 0.1f);
            }
            player.func_71038_i();
        }
        return stack;
    }

    public AspectList getVisCost(ItemStack stack) {
        AspectList list = costBase.copy();
        if (TaintedMagicHelper.hasFocusUpgrade(stack, persistant)) {
            list.add(costPersistant);
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        if (ConfigHandler.taintStormStaffMultiple != 1.0f) {
            list = TaintedMagicHelper.addTooltipDamageAndStaffMultiplier(list, ConfigHandler.visShardBaseDamage, stack, ConfigHandler.visShardStaffMultiple);
        }
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack s, int r) {
        switch (r) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, persistant};
            }
        }
        return null;
    }
}

