/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.gen;

import chylex.hee.init.BlockList;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import chylex.hee.world.structure.util.pregen.LargeStructureWorld;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;

public class OreGenerator {
    private static final byte attemptMp = 3;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private final List<OreLocationList> oreListStardust = new ArrayList<OreLocationList>();
    private final List<OreLocationList> oreListInstabilityOrb = new ArrayList<OreLocationList>();

    public OreGenerator(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public void setup(Random rand, IslandBiomeBase biome) {
        int a;
        int amount = (int)(495.0f * biome.getOreAmountMultiplier());
        for (a = 0; a < amount; ++a) {
            this.generateOreCluster(this.oreListStardust, rand, 3 + rand.nextInt(7));
        }
        amount = (int)(260.0f * biome.getOreAmountMultiplier());
        for (a = 0; a < amount; ++a) {
            this.generateOreCluster(this.oreListInstabilityOrb, rand, 1 + rand.nextInt(3));
        }
    }

    public void generate(LargeStructureWorld world, Random rand) {
        BlockPosM loc;
        int attemptAm;
        int attempt = 0;
        int placed = 0;
        for (OreLocationList list : this.oreListStardust) {
            attemptAm = list.placeAmount * 3;
            placed = 0;
            for (attempt = 0; attempt < attemptAm && placed < list.placeAmount; ++attempt) {
                loc = (BlockPosM)list.blockList.get(attempt);
                if (loc.y < 0 || world.getBlock(loc.x, loc.y, loc.z) != Blocks.field_150377_bs) continue;
                world.setBlock(loc.x, loc.y, loc.z, BlockList.stardust_ore, rand.nextInt(15) + 1);
                ++placed;
            }
        }
        for (OreLocationList list : this.oreListInstabilityOrb) {
            attemptAm = list.placeAmount * 3;
            placed = 0;
            for (attempt = 0; attempt < attemptAm && placed < list.placeAmount; ++attempt) {
                loc = (BlockPosM)list.blockList.get(attempt);
                if (loc.y < 0 || world.getBlock(loc.x, loc.y, loc.z) != Blocks.field_150377_bs) continue;
                world.setBlock(loc.x, loc.y, loc.z, BlockList.instability_orb_ore);
                ++placed;
            }
        }
    }

    private void generateOreCluster(List<OreLocationList> locList, Random rand, int amount) {
        int xx = rand.nextInt(this.maxX - this.minX + 1) + this.minX;
        int yy = rand.nextInt(this.maxY - this.minY + 1) + this.minY;
        int zz = rand.nextInt(this.maxZ - this.minZ + 1) + this.minZ;
        double sqrtAmount = Math.sqrt((double)amount * 1.75);
        OreLocationList list = new OreLocationList(amount);
        if (yy < this.minY + 14) {
            yy = rand.nextInt(this.maxY - this.minY + 1) + this.minY;
        }
        int n = amount * 3;
        for (int a = 0; a < n; ++a) {
            list.blockList.add(new BlockPosM((double)xx + (double)MathHelper.func_76134_b((float)((float)(rand.nextDouble() * 2.0 * Math.PI))) * sqrtAmount * rand.nextDouble(), (double)yy + (double)MathHelper.func_76134_b((float)((float)(rand.nextDouble() * 2.0 * Math.PI))) * sqrtAmount * rand.nextDouble(), (double)zz + (double)MathHelper.func_76134_b((float)((float)(rand.nextDouble() * 2.0 * Math.PI))) * sqrtAmount * rand.nextDouble()));
        }
        locList.add(list);
    }

    private class OreLocationList {
        private final List<BlockPosM> blockList;
        private final byte placeAmount;

        public OreLocationList(int amount) {
            this.blockList = new ArrayList<BlockPosM>(amount * 3);
            this.placeAmount = (byte)amount;
        }
    }
}

