/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.misc;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.item.ItemTempleCaller;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.system.logging.Log;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.DragonSavefile;
import chylex.hee.system.savedata.types.EnergySavefile;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.world.feature.TempleGenerator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.io.FileUtils;

public final class TempleEvents {
    private static TempleEvents instance;
    private DestroyStage stage = DestroyStage.SILENT;
    private byte tickTimer = 0;
    private byte giveUpCounter = 0;

    public static void register() {
        instance = new TempleEvents();
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    public static void destroyWorld() {
        if (instance == null) {
            throw new RuntimeException("TempleEvents class has not been registered!");
        }
        if (TempleEvents.instance.stage == DestroyStage.SILENT) {
            instance.setStage(DestroyStage.KICK);
            ((DragonSavefile)WorldDataHandler.get(DragonSavefile.class)).setDestroyEnd(true);
        }
    }

    public static boolean attemptDestroyTemple(EntityPlayer player) {
        DragonSavefile save = (DragonSavefile)WorldDataHandler.get(DragonSavefile.class);
        Set<UUID> playersInTemple = save.getPlayersInTemple();
        if (playersInTemple.contains(player.func_146103_bH().getId())) {
            if (playersInTemple.size() == 1 && !save.shouldPreventTempleDestruction()) {
                save.resetPlayersInTemple();
                new TempleGenerator((World)DimensionManager.getWorld((int)1)).preloadAndClearArea(ItemTempleCaller.templeX, ItemTempleCaller.templeY, ItemTempleCaller.templeZ);
            } else {
                save.setPlayerIsInTemple(player, false);
            }
            return true;
        }
        return false;
    }

    private TempleEvents() {
    }

    private void setStage(DestroyStage stage) {
        this.stage = stage;
        this.tickTimer = 0;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (this.stage == DestroyStage.SILENT || e.phase != TickEvent.Phase.START || (this.tickTimer = (byte)(this.tickTimer + 1)) < this.stage.tickTimer) {
            return;
        }
        this.tickTimer = 0;
        Log.debug("End dimension deletion stage: $0", new Object[]{this.stage});
        WorldServer world = DimensionManager.getWorld((int)1);
        if (this.stage == DestroyStage.KICK) {
            this.giveUpCounter = 0;
            if (world == null) {
                this.setStage(DestroyStage.DELETE);
            } else if (world.field_73010_i.isEmpty()) {
                this.setStage(DestroyStage.UNLOAD);
            } else {
                ArrayList players = new ArrayList(world.field_73010_i);
                for (EntityPlayerMP player : players) {
                    if (player.field_70154_o != null) {
                        player.func_70078_a(null);
                    }
                    DragonUtil.teleportToOverworld(player);
                }
            }
        } else if (this.stage == DestroyStage.UNLOAD) {
            if (world == null) {
                this.stage = DestroyStage.DELETE;
            } else {
                DimensionManager.unloadWorld((int)1);
                this.setStage(DestroyStage.WAIT_FOR_UNLOAD);
            }
        } else if (this.stage == DestroyStage.DELETE) {
            File dim1 = new File(DimensionManager.getCurrentSaveRootDirectory(), "DIM1");
            if (!dim1.exists()) {
                Log.reportedError("DIM1 not found!", new Object[0]);
                this.setStage(DestroyStage.SILENT);
                return;
            }
            boolean successful = true;
            try {
                FileUtils.cleanDirectory((File)dim1);
                dim1.delete();
            }
            catch (Exception ex) {
                successful = false;
                Log.throwable(ex, "Error deleting DIM1!", new Object[0]);
            }
            if (successful) {
                DragonSavefile save = (DragonSavefile)WorldDataHandler.get(DragonSavefile.class);
                save.setDestroyEnd(false);
                save.setPreventTempleDestruction(false);
                save.resetPlayersInTemple();
                save.addDragonDeath();
                save.setDragonDead(false);
                save.resetCrystals();
                ((EnergySavefile)WorldDataHandler.get(EnergySavefile.class)).reset();
                WorldDataHandler.forceSave();
                this.setStage(DestroyStage.SILENT);
                Log.debug("Successfully deleted!", new Object[0]);
            } else {
                this.giveUpCounter = (byte)(this.giveUpCounter + 1);
                if (this.giveUpCounter > 10) {
                    Log.reportedError("Gave up deleting DIM1, please " + (HardcoreEnderExpansion.proxy.getClass() == ModCommonProxy.class ? "restart the server" : "reload the world") + " to try again, or delete 'DIM1' manually if the deletion keeps failing.", new Object[0]);
                    this.setStage(DestroyStage.SILENT);
                    this.giveUpCounter = 0;
                }
            }
        }
    }

    @SubscribeEvent
    public void onGetBlockBreakSpeed(PlayerEvent.BreakSpeed e) {
        if (e.entityPlayer.field_71093_bK == 1 && TempleEvents.isPlayerInTemple(e.entityPlayer)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent e) {
        if (e.entity.field_70170_p.field_72995_K || e.entity.field_71093_bK != 1 || !TempleEvents.isPlayerInTemple(e.entityPlayer)) {
            return;
        }
        ItemStack is = e.entityPlayer.field_71071_by.func_70448_g();
        if (is == null) {
            return;
        }
        if ((e.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR || e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) && is.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150380_bt)) {
            e.useBlock = Event.Result.DENY;
            e.useItem = Event.Result.DENY;
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        if (e.player.field_71093_bK == 1 && TempleEvents.attemptDestroyTemple(e.player)) {
            e.player.func_70634_a(0.0, (double)(1 + DragonUtil.getTopBlockY(e.player.field_70170_p, Blocks.field_150377_bs, 0, 0, 100)), 0.0);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload e) {
        if (e.world.field_73011_w.field_76574_g == 1 && TempleEvents.instance.stage == DestroyStage.WAIT_FOR_UNLOAD) {
            instance.setStage(DestroyStage.DELETE);
        }
    }

    public static boolean isPlayerInTemple(EntityPlayer player) {
        return player.field_70163_u >= (double)ItemTempleCaller.templeY && player.field_70165_t >= (double)ItemTempleCaller.templeX && player.field_70161_v >= (double)ItemTempleCaller.templeZ && player.field_70163_u <= (double)(ItemTempleCaller.templeY + 7) && player.field_70165_t <= (double)(ItemTempleCaller.templeX + 13) && player.field_70161_v <= (double)(ItemTempleCaller.templeZ + 19);
    }

    protected static enum DestroyStage {
        SILENT(-1),
        KICK(8),
        UNLOAD(3),
        WAIT_FOR_UNLOAD(69),
        DELETE(100);

        protected byte tickTimer;

        private DestroyStage(int tickTimer) {
            this.tickTimer = (byte)tickTimer;
        }
    }
}

