/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCraftingCpuChange;
import appeng.api.util.WorldCoord;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.MBCalculator;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.TileCraftingTile;
import java.util.Iterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CraftingCPUCalculator
extends MBCalculator {
    private final TileCraftingTile tqb;

    public CraftingCPUCalculator(IAEMultiBlock t) {
        super(t);
        this.tqb = (TileCraftingTile)t;
    }

    @Override
    public boolean checkMultiblockScale(WorldCoord min, WorldCoord max) {
        if (max.x - min.x > 16) {
            return false;
        }
        if (max.y - min.y > 16) {
            return false;
        }
        return max.z - min.z <= 16;
    }

    @Override
    public IAECluster createCluster(World w, WorldCoord min, WorldCoord max) {
        return new CraftingCPUCluster(min, max);
    }

    @Override
    public boolean verifyInternalStructure(World w, WorldCoord min, WorldCoord max) {
        boolean storage = false;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    IAEMultiBlock te = (IAEMultiBlock)w.func_147438_o(x, y, z);
                    if (!te.isValid()) {
                        return false;
                    }
                    if (storage || !(te instanceof TileCraftingTile)) continue;
                    storage = ((TileCraftingTile)te).getStorageBytes() > 0L;
                }
            }
        }
        return storage;
    }

    @Override
    public void disconnect() {
        this.tqb.disconnect(true);
    }

    @Override
    public void updateTiles(IAECluster cl, World w, WorldCoord min, WorldCoord max) {
        CraftingCPUCluster c = (CraftingCPUCluster)cl;
        for (int x = min.x; x <= max.x; ++x) {
            for (int y = min.y; y <= max.y; ++y) {
                for (int z = min.z; z <= max.z; ++z) {
                    TileCraftingTile te = (TileCraftingTile)w.func_147438_o(x, y, z);
                    te.updateStatus(c);
                    c.addTile(te);
                }
            }
        }
        c.done();
        Iterator<IGridHost> i = c.getTiles();
        while (i.hasNext()) {
            IGrid g;
            IGridHost gh = i.next();
            IGridNode n = gh.getGridNode(ForgeDirection.UNKNOWN);
            if (n == null || (g = n.getGrid()) == null) continue;
            g.postEvent(new MENetworkCraftingCpuChange(n));
            return;
        }
    }

    @Override
    public boolean isValidTile(TileEntity te) {
        return te instanceof TileCraftingTile;
    }
}

