/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IGrinderEntry;
import appeng.api.features.IGrinderRegistry;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.registries.entries.AppEngGrinderRecipe;
import appeng.recipes.ores.IOreListener;
import appeng.recipes.ores.OreDictionaryHandler;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public final class GrinderRecipeManager
implements IGrinderRegistry,
IOreListener {
    private final List<IGrinderEntry> recipes = new ArrayList<IGrinderEntry>();
    private final Map<ItemStack, String> ores = new HashMap<ItemStack, String>();
    private final Map<ItemStack, String> ingots = new HashMap<ItemStack, String>();
    private final Map<String, ItemStack> dusts = new HashMap<String, ItemStack>();

    public GrinderRecipeManager() {
        this.addOre("Coal", new ItemStack(Items.field_151044_h));
        this.addOre("Charcoal", new ItemStack(Items.field_151044_h, 1, 1));
        this.addOre("NetherQuartz", new ItemStack(Blocks.field_150449_bY));
        this.addIngot("NetherQuartz", new ItemStack(Items.field_151128_bU));
        this.addOre("Gold", new ItemStack(Blocks.field_150352_o));
        this.addIngot("Gold", new ItemStack(Items.field_151043_k));
        this.addOre("Iron", new ItemStack(Blocks.field_150366_p));
        this.addIngot("Iron", new ItemStack(Items.field_151042_j));
        this.addOre("Obsidian", new ItemStack(Blocks.field_150343_Z));
        this.addIngot("Ender", new ItemStack(Items.field_151079_bi));
        this.addIngot("EnderPearl", new ItemStack(Items.field_151079_bi));
        this.addIngot("Wheat", new ItemStack(Items.field_151015_O));
        OreDictionaryHandler.INSTANCE.observe(this);
    }

    @Override
    public List<IGrinderEntry> getRecipes() {
        this.log("API - getRecipes");
        return this.recipes;
    }

    @Override
    public void addRecipe(ItemStack in, ItemStack out, int cost) {
        if (in == null || out == null) {
            this.log("Invalid Grinder Recipe Specified.");
            return;
        }
        this.log("Allow Grinding of " + Platform.getItemDisplayName(in) + " to " + Platform.getItemDisplayName(out) + " for " + cost);
        this.injectRecipe(new AppEngGrinderRecipe(this.copy(in), this.copy(out), cost));
    }

    @Override
    public void addRecipe(ItemStack in, ItemStack out, ItemStack optional, float chance, int cost) {
        if (in == null || optional == null && out == null) {
            this.log("Invalid Grinder Recipe Specified.");
            return;
        }
        this.log("Allow Grinding of " + Platform.getItemDisplayName(in) + " to " + Platform.getItemDisplayName(out) + " with optional " + Platform.getItemDisplayName(optional) + " for " + cost);
        this.injectRecipe(new AppEngGrinderRecipe(this.copy(in), this.copy(out), this.copy(optional), chance, cost));
    }

    @Override
    public void addRecipe(ItemStack in, ItemStack out, ItemStack optional, float chance, ItemStack optional2, float chance2, int cost) {
        if (in == null || optional == null && out == null && optional2 == null) {
            this.log("Invalid Grinder Recipe Specified.");
            return;
        }
        this.log("Allow Grinding of " + Platform.getItemDisplayName(in) + " to " + Platform.getItemDisplayName(out) + " with optional " + Platform.getItemDisplayName(optional) + " for " + cost);
        this.injectRecipe(new AppEngGrinderRecipe(this.copy(in), this.copy(out), this.copy(optional), this.copy(optional2), chance, chance2, cost));
    }

    private void injectRecipe(AppEngGrinderRecipe appEngGrinderRecipe) {
        for (IGrinderEntry gr : this.recipes) {
            if (!Platform.isSameItemPrecise(gr.getInput(), appEngGrinderRecipe.getInput())) continue;
            return;
        }
        this.recipes.add(appEngGrinderRecipe);
    }

    private ItemStack copy(ItemStack is) {
        if (is != null) {
            return is.func_77946_l();
        }
        return null;
    }

    @Override
    public IGrinderEntry getRecipeForInput(ItemStack input) {
        this.log("Looking up recipe for " + Platform.getItemDisplayName(input));
        if (input != null) {
            for (IGrinderEntry r : this.recipes) {
                if (!Platform.isSameItem(input, r.getInput())) continue;
                this.log("Recipe for " + input.func_77977_a() + " found " + Platform.getItemDisplayName(r.getOutput()));
                return r;
            }
            this.log("Could not find recipe for " + Platform.getItemDisplayName(input));
        }
        return null;
    }

    private void log(String o) {
        AELog.grinder(o);
    }

    private int getDustToOreRatio(String name) {
        if (name.equals("Obsidian")) {
            return 1;
        }
        if (name.equals("Charcoal")) {
            return 1;
        }
        if (name.equals("Coal")) {
            return 1;
        }
        return 2;
    }

    private void addOre(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        this.log("Adding Ore - " + name + " : " + Platform.getItemDisplayName(item));
        this.ores.put(item, name);
        if (this.dusts.containsKey(name)) {
            ItemStack is = this.dusts.get(name).func_77946_l();
            int ratio = this.getDustToOreRatio(name);
            if (ratio > 1) {
                ItemStack extra = is.func_77946_l();
                extra.field_77994_a = ratio - 1;
                this.addRecipe(item, is, extra, (float)(AEConfig.instance.oreDoublePercentage / 100.0), 8);
            } else {
                this.addRecipe(item, is, 8);
            }
        }
    }

    private void addIngot(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        this.log("Adding Ingot - " + name + " : " + Platform.getItemDisplayName(item));
        this.ingots.put(item, name);
        if (this.dusts.containsKey(name)) {
            this.addRecipe(item, this.dusts.get(name), 4);
        }
    }

    private void addDust(String name, ItemStack item) {
        if (item == null) {
            return;
        }
        if (this.dusts.containsKey(name)) {
            this.log("Rejecting Dust - " + name + " : " + Platform.getItemDisplayName(item));
            return;
        }
        this.log("Adding Dust - " + name + " : " + Platform.getItemDisplayName(item));
        this.dusts.put(name, item);
        for (Map.Entry<ItemStack, String> d : this.ores.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            ItemStack is = item.func_77946_l();
            is.field_77994_a = 1;
            int ratio = this.getDustToOreRatio(name);
            if (ratio > 1) {
                ItemStack extra = is.func_77946_l();
                extra.field_77994_a = ratio - 1;
                this.addRecipe(d.getKey(), is, extra, (float)(AEConfig.instance.oreDoublePercentage / 100.0), 8);
                continue;
            }
            this.addRecipe(d.getKey(), is, 8);
        }
        for (Map.Entry<ItemStack, String> d : this.ingots.entrySet()) {
            if (!name.equals(d.getValue())) continue;
            this.addRecipe(d.getKey(), item, 4);
        }
    }

    @Override
    public void oreRegistered(String name, ItemStack item) {
        if (name.startsWith("ore") || name.startsWith("crystal") || name.startsWith("gem") || name.startsWith("ingot") || name.startsWith("dust")) {
            for (String ore : AEConfig.instance.grinderOres) {
                if (name.equals("ore" + ore)) {
                    this.addOre(ore, item);
                    continue;
                }
                if (name.equals("crystal" + ore) || name.equals("ingot" + ore) || name.equals("gem" + ore)) {
                    this.addIngot(ore, item);
                    continue;
                }
                if (!name.equals("dust" + ore)) continue;
                this.addDust(ore, item);
            }
        }
    }
}

