/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.me.cache.GridStorageCache;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerNetworkStatus
extends AEBaseContainer {
    @GuiSync(value=0)
    public long avgAddition;
    @GuiSync(value=1)
    public long powerUsage;
    @GuiSync(value=2)
    public long currentPower;
    @GuiSync(value=3)
    public long maxPower;
    @GuiSync(value=4)
    public long itemBytesTotal;
    @GuiSync(value=5)
    public long itemBytesUsed;
    @GuiSync(value=6)
    public long itemTypesTotal;
    @GuiSync(value=7)
    public long itemTypesUsed;
    @GuiSync(value=8)
    public long itemCellG;
    @GuiSync(value=9)
    public long itemCellO;
    @GuiSync(value=10)
    public long itemCellR;
    @GuiSync(value=11)
    public long fluidBytesTotal;
    @GuiSync(value=12)
    public long fluidBytesUsed;
    @GuiSync(value=13)
    public long fluidTypesTotal;
    @GuiSync(value=14)
    public long fluidTypesUsed;
    @GuiSync(value=15)
    public long fluidCellG;
    @GuiSync(value=16)
    public long fluidCellO;
    @GuiSync(value=17)
    public long fluidCellR;
    @GuiSync(value=18)
    public long essentiaBytesTotal;
    @GuiSync(value=19)
    public long essentiaBytesUsed;
    @GuiSync(value=20)
    public long essentiaTypesTotal;
    @GuiSync(value=21)
    public long essentiaTypesUsed;
    @GuiSync(value=22)
    public long essentiaCellG;
    @GuiSync(value=23)
    public long essentiaCellO;
    @GuiSync(value=24)
    public long essentiaCellR;
    @GuiSync(value=25)
    public long itemCellCount;
    @GuiSync(value=26)
    public long fluidCellCount;
    @GuiSync(value=27)
    public long essentiaCellCount;
    private IGrid network;
    private int delay = 40;

    public ContainerNetworkStatus(InventoryPlayer ip, INetworkTool te) {
        super(ip, null, null);
        IGridHost host = te.getGridHost();
        if (host != null) {
            this.findNode(host, ForgeDirection.UNKNOWN);
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                this.findNode(host, d);
            }
        }
        if (this.network == null && Platform.isServer()) {
            this.setValidContainer(false);
        }
    }

    private void findNode(IGridHost host, ForgeDirection d) {
        IGridNode node;
        if (this.network == null && (node = host.getGridNode(d)) != null) {
            this.network = node.getGrid();
        }
    }

    @Override
    public void func_75142_b() {
        ++this.delay;
        if (Platform.isServer() && this.delay > 15 && this.network != null) {
            GridStorageCache sg;
            this.delay = 0;
            IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
            if (eg != null) {
                this.setAverageAddition((long)(100.0 * eg.getAvgPowerInjection()));
                this.setPowerUsage((long)(100.0 * eg.getAvgPowerUsage()));
                this.setCurrentPower((long)(100.0 * eg.getStoredPower()));
                this.setMaxPower((long)(100.0 * eg.getMaxStoredPower()));
            }
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                for (Class clazz : this.network.getMachinesClasses()) {
                    IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
                    for (IGridNode machine : this.network.getMachines(clazz)) {
                        IGridBlock blk = machine.getGridBlock();
                        ItemStack is = blk.getMachineRepresentation();
                        if (is == null || is.func_77973_b() == null) continue;
                        AEItemStack ais = AEItemStack.create(is);
                        ais.setStackSize(1L);
                        ais.setCountRequestable((long)PowerMultiplier.CONFIG.multiply(blk.getIdlePowerUsage() * 100.0));
                        list.add(ais);
                    }
                    for (IAEItemStack ais : list) {
                        piu.appendItem(ais);
                    }
                }
                for (Object object : this.field_75149_d) {
                    if (!(object instanceof EntityPlayer)) continue;
                    NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)object);
                }
            }
            catch (IOException piu) {
                // empty catch block
            }
            if ((sg = (GridStorageCache)this.network.getCache(IStorageGrid.class)) != null) {
                this.itemBytesUsed = Double.doubleToLongBits(sg.getItemBytesUsed());
                this.itemBytesTotal = Double.doubleToLongBits(sg.getItemBytesTotal());
                this.itemCellG = sg.getItemCellG();
                this.itemCellO = sg.getItemCellO();
                this.itemCellR = sg.getItemCellR();
                this.itemCellCount = sg.getItemCellCount();
                this.itemTypesUsed = sg.getItemTypesUsed();
                this.itemTypesTotal = sg.getItemTypesTotal();
                this.fluidBytesUsed = Double.doubleToLongBits(sg.getFluidBytesUsed());
                this.fluidBytesTotal = Double.doubleToLongBits(sg.getFluidBytesTotal());
                this.fluidCellG = sg.getFluidCellG();
                this.fluidCellO = sg.getFluidCellO();
                this.fluidCellR = sg.getFluidCellR();
                this.fluidCellCount = sg.getFluidCellCount();
                this.fluidTypesUsed = sg.getFluidTypesUsed();
                this.fluidTypesTotal = sg.getFluidTypesTotal();
                this.essentiaBytesUsed = Double.doubleToLongBits(sg.getEssentiaBytesUsed());
                this.essentiaBytesTotal = Double.doubleToLongBits(sg.getEssentiaBytesTotal());
                this.essentiaCellG = sg.getEssentiaCellG();
                this.essentiaCellO = sg.getEssentiaCellO();
                this.essentiaCellR = sg.getEssentiaCellR();
                this.essentiaCellCount = sg.getEssentiaCellCount();
                this.essentiaTypesUsed = sg.getEssentiaTypesUsed();
                this.essentiaTypesTotal = sg.getEssentiaTypesTotal();
            }
        }
        super.func_75142_b();
    }

    public long getCurrentPower() {
        return this.currentPower;
    }

    private void setCurrentPower(long currentPower) {
        this.currentPower = currentPower;
    }

    public long getMaxPower() {
        return this.maxPower;
    }

    private void setMaxPower(long maxPower) {
        this.maxPower = maxPower;
    }

    public long getAverageAddition() {
        return this.avgAddition;
    }

    private void setAverageAddition(long avgAddition) {
        this.avgAddition = avgAddition;
    }

    public long getPowerUsage() {
        return this.powerUsage;
    }

    private void setPowerUsage(long powerUsage) {
        this.powerUsage = powerUsage;
    }

    public long getItemBytesTotal() {
        return this.itemBytesTotal;
    }

    public long getItemBytesUsed() {
        return this.itemBytesUsed;
    }

    public long getItemTypesTotal() {
        return this.itemTypesTotal;
    }

    public long getItemTypesUsed() {
        return this.itemTypesUsed;
    }

    public long getItemCellG() {
        return this.itemCellG;
    }

    public long getItemCellO() {
        return this.itemCellO;
    }

    public long getItemCellR() {
        return this.itemCellR;
    }

    public long getFluidBytesTotal() {
        return this.fluidBytesTotal;
    }

    public long getFluidBytesUsed() {
        return this.fluidBytesUsed;
    }

    public long getFluidTypesTotal() {
        return this.fluidTypesTotal;
    }

    public long getFluidTypesUsed() {
        return this.fluidTypesUsed;
    }

    public long getFluidCellG() {
        return this.fluidCellG;
    }

    public long getFluidCellO() {
        return this.fluidCellO;
    }

    public long getFluidCellR() {
        return this.fluidCellR;
    }

    public long getEssentiaBytesTotal() {
        return this.essentiaBytesTotal;
    }

    public long getEssentiaBytesUsed() {
        return this.essentiaBytesUsed;
    }

    public long getEssentiaTypesTotal() {
        return this.essentiaTypesTotal;
    }

    public long getEssentiaTypesUsed() {
        return this.essentiaTypesUsed;
    }

    public long getEssentiaCellG() {
        return this.essentiaCellG;
    }

    public long getEssentiaCellO() {
        return this.essentiaCellO;
    }

    public long getEssentiaCellR() {
        return this.essentiaCellR;
    }

    public long getItemCellCount() {
        return this.itemCellCount;
    }

    public long getFluidCellCount() {
        return this.fluidCellCount;
    }

    public long getEssentiaCellCount() {
        return this.essentiaCellCount;
    }
}

