/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.util;

import java.lang.reflect.Field;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassTransformer
implements IClassTransformer {
    public byte[] transform(String arg0, String arg1, byte[] arg2) {
        return arg2;
    }

    public static boolean isObfuscated(String name) {
        return !name.contains(".");
    }

    public static void setFinal(Field field, Object owner, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(owner, newValue);
    }

    public static void listMethods(ClassNode cn) {
        System.out.println("Mapping bug detected! Listing methods: ");
        for (MethodNode methodd : cn.methods) {
            System.out.println("- " + methodd.name + methodd.desc);
        }
    }

    public static LabelNode newLabelNode() {
        Label l = new Label();
        LabelNode ln = new LabelNode(l);
        l.info = ln;
        return ln;
    }

    public static ClassNode getClassNode(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static ClassNode getClassNode(String name) {
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(name);
            classReader.accept((ClassVisitor)classNode, 0);
            return classNode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] writeBytecode(ClassNode node) {
        ClassWriter writer = new ClassWriter(1);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static byte[] writeBytecodeFrames(ClassNode node) {
        ClassWriter writer = new ClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static String getName(String className, String deobfName, String obfName) {
        return ClassTransformer.isObfuscated(className) ? obfName : deobfName;
    }

    public static MethodNode getMethod(ClassNode node, String mName, String mSig) {
        for (MethodNode m : node.methods) {
            if (!m.name.equals(mName) || !m.desc.equals(mSig)) continue;
            return m;
        }
        return null;
    }

    public static FieldNode getField(ClassNode node, String mName, String mSig) {
        for (FieldNode f : node.fields) {
            if (!f.name.equals(mName) || !f.desc.equals(mSig)) continue;
            return f;
        }
        return null;
    }
}

