/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.GuiNaturesCompass;
import com.chaosthedude.naturescompass.gui.GuiTransparentButton;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.biome.BiomeGenBase;

@SideOnly(value=Side.CLIENT)
public class GuiBiomeInfo
extends GuiScreen {
    private GuiNaturesCompass parentScreen;
    private BiomeGenBase biome;
    private GuiButton searchButton;
    private GuiButton backButton;
    private String baseHeight;
    private String heightVariation;
    private String precipitation;
    private String climate;
    private String humidity;
    private List<String> biomeTags = new ArrayList<String>();

    public GuiBiomeInfo(GuiNaturesCompass parentScreen, BiomeGenBase biome) {
        this.parentScreen = parentScreen;
        this.biome = biome;
        this.baseHeight = biome.field_76748_D < -1.0f ? I18n.func_135052_a((String)"string.naturescompass.veryLow", (Object[])new Object[0]) : (biome.field_76748_D < 0.0f ? I18n.func_135052_a((String)"string.naturescompass.low", (Object[])new Object[0]) : (biome.field_76748_D < 0.4f ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : (biome.field_76748_D < 1.0f ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0]))));
        this.baseHeight = this.baseHeight + "(" + biome.field_76748_D + ")";
        this.heightVariation = biome.field_76749_E < 0.3f ? I18n.func_135052_a((String)"string.naturescompass.average", (Object[])new Object[0]) : (biome.field_76749_E < 0.6f ? I18n.func_135052_a((String)"string.naturescompass.high", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.veryHigh", (Object[])new Object[0]));
        this.heightVariation = this.heightVariation + "(" + biome.field_76749_E + ")";
        this.precipitation = biome.func_76746_c() ? I18n.func_135052_a((String)"string.naturescompass.snow", (Object[])new Object[0]) : (biome.field_76751_G > 0.0f ? I18n.func_135052_a((String)"string.naturescompass.rain", (Object[])new Object[0]) : I18n.func_135052_a((String)"string.naturescompass.none", (Object[])new Object[0]));
        this.climate = BiomeUtils.getBiomeClimate(biome);
        this.climate = this.climate + "(" + (int)(biome.field_76750_F * 100.0f) + "\u00b0F)";
        this.humidity = BiomeUtils.getBiomeHumidity(biome);
        this.humidity = this.humidity + "(" + (int)(biome.field_76751_G * 100.0f) + "%)";
        int length = 0;
        StringBuilder tags = new StringBuilder();
        for (String tag : BiomeUtils.getListBiomeTags(biome)) {
            if ((length += (tag = tag.substring(0, 1).toUpperCase() + tag.substring(1)).length()) <= 20) {
                tags.append(tag).append(", ");
                continue;
            }
            this.biomeTags.add(tags.toString());
            tags = new StringBuilder(tag + ", ");
            length = tag.length();
        }
        tags = new StringBuilder(tags.substring(0, tags.length() - 2));
        this.biomeTags.add(tags.toString());
    }

    public void func_73866_w_() {
        this.setupButtons();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button == this.searchButton) {
                this.parentScreen.searchForBiome(this.biome);
            } else if (button == this.backButton) {
                this.field_146297_k.func_147108_a((GuiScreen)this.parentScreen);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, BiomeUtils.getBiomeName(this.biome), this.field_146294_l / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.precipitation", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 40, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.precipitation, this.field_146294_l / 2 - 100, 50, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.baseHeight", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 70, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.baseHeight, this.field_146294_l / 2 - 100, 80, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.humidity", (Object[])new Object[0]), this.field_146294_l / 2 - 100, 100, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.humidity, this.field_146294_l / 2 - 100, 110, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.climate", (Object[])new Object[0]), this.field_146294_l / 2 + 40, 40, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.climate, this.field_146294_l / 2 + 40, 50, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.heightVariation", (Object[])new Object[0]), this.field_146294_l / 2 + 40, 70, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, this.heightVariation, this.field_146294_l / 2 + 40, 80, 0x808080);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"string.naturescompass.tags", (Object[])new Object[0]), this.field_146294_l / 2 + 40, 100, 0xFFFFFF);
        for (int i = 0; i < this.biomeTags.size(); ++i) {
            this.func_73731_b(this.field_146289_q, this.biomeTags.get(i), this.field_146294_l / 2 + 40, 110 + i * 10, 0x808080);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected <T extends GuiButton> T addButton(T button) {
        this.field_146292_n.add(button);
        return button;
    }

    private void setupButtons() {
        this.field_146292_n.clear();
        this.backButton = this.addButton(new GuiTransparentButton(0, this.field_146294_l / 2 - 154, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"string.naturescompass.back", (Object[])new Object[0])));
        this.searchButton = this.addButton(new GuiTransparentButton(1, this.field_146294_l / 2 + 4, this.field_146295_m - 52, 150, 20, I18n.func_135052_a((String)"string.naturescompass.search", (Object[])new Object[0])));
    }
}

