/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import cpw.mods.fml.common.ModContainer;
import glowredman.txloader.RemoteHandler;
import glowredman.txloader.TXLoaderCore;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public class TXResourcePack
implements IResourcePack {
    private final String name;
    private final Path dir;

    private TXResourcePack(String name, Path dir) {
        this.name = name;
        this.dir = dir;
    }

    public InputStream func_110590_a(ResourceLocation rl) throws IOException {
        return new FileInputStream(this.getResourcePath(rl).toFile());
    }

    public boolean func_110589_b(ResourceLocation rl) {
        return Files.exists(this.getResourcePath(rl), new LinkOption[0]);
    }

    public Set func_110587_b() {
        if (TXLoaderCore.isRemoteReachable) {
            RemoteHandler.getAssets();
        }
        File[] subDirs = this.dir.toFile().listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        HashSet<String> resourceDomains = new HashSet<String>();
        for (File f : subDirs) {
            resourceDomains.add(f.getName());
        }
        return resourceDomains;
    }

    public IMetadataSection func_135058_a(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() {
        return null;
    }

    public String func_130077_b() {
        return this.name;
    }

    private Path getResourcePath(ResourceLocation rl) {
        return this.dir.resolve(rl.func_110624_b()).resolve(rl.func_110623_a());
    }

    public static class Force
    extends TXResourcePack {
        public Force() {
            super("TX Loader Forced Resources", TXLoaderCore.forceResourcesDir.toPath());
            TXLoaderCore.forceResourcesDir.mkdir();
        }
    }

    public static class Normal
    extends TXResourcePack {
        public Normal(ModContainer modContainer) {
            super("TX Loader Resources", TXLoaderCore.resourcesDir.toPath());
            TXLoaderCore.resourcesDir.mkdir();
        }
    }
}

