/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import com.google.common.reflect.TypeToken;
import glowredman.txloader.Asset;
import glowredman.txloader.TXLoaderCore;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

class ConfigHandler {
    private static File configFile;
    private static final Type TYPE;

    ConfigHandler() {
    }

    static void load() {
        configFile = new File(TXLoaderCore.configDir, "config.json");
        if (!configFile.exists()) {
            try {
                FileUtils.write((File)configFile, (CharSequence)TXLoaderCore.GSON.toJson(new ArrayList()), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                TXLoaderCore.LOGGER.error("Failed to create config file!", (Throwable)e);
            }
            return;
        }
        try {
            TXLoaderCore.REMOTE_ASSETS.addAll((Collection)TXLoaderCore.GSON.fromJson(FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8), TYPE));
        }
        catch (Exception e) {
            TXLoaderCore.LOGGER.error("Failed to read config file!", (Throwable)e);
            return;
        }
        TXLoaderCore.LOGGER.info("Successfully read config file.");
        ConfigHandler.moveRLAssets();
    }

    static boolean save() {
        try {
            FileUtils.write((File)configFile, (CharSequence)TXLoaderCore.GSON.toJson(TXLoaderCore.REMOTE_ASSETS.parallelStream().filter(a -> !a.addedByMod).collect(Collectors.toList()), TYPE), (Charset)StandardCharsets.UTF_8);
            return true;
        }
        catch (Exception e) {
            TXLoaderCore.LOGGER.error("Failed saving config!", (Throwable)e);
            return false;
        }
    }

    static void moveRLAssets() {
        File resources = new File(TXLoaderCore.mcLocation, "resources");
        File oresources = new File(TXLoaderCore.mcLocation, "oresources");
        if (resources.exists()) {
            TXLoaderCore.LOGGER.info("Attempting to move assets from ./resources/ to ./config/txloader/load/ ...");
            for (File f : resources.listFiles()) {
                try {
                    FileUtils.moveToDirectory((File)f, (File)TXLoaderCore.resourcesDir, (boolean)false);
                    TXLoaderCore.LOGGER.debug("Successfully moved " + f.getName() + " to ./config/txloader/load/");
                }
                catch (Exception e) {
                    TXLoaderCore.LOGGER.warn("Failed to move " + f.getName() + " to ./config/txloader/load/", (Throwable)e);
                }
            }
            try {
                resources.delete();
            }
            catch (Exception e) {
                TXLoaderCore.LOGGER.warn("Failed to delete ./resources/", (Throwable)e);
            }
        }
        if (oresources.exists()) {
            TXLoaderCore.LOGGER.info("Attempting to move assets from ./oresources/ to ./config/txloader/forceload/ ...");
            for (File f : oresources.listFiles()) {
                try {
                    FileUtils.moveToDirectory((File)f, (File)TXLoaderCore.forceResourcesDir, (boolean)false);
                    TXLoaderCore.LOGGER.debug("Successfully moved " + f.getName() + " to ./config/txloader/forceload/");
                }
                catch (Exception e) {
                    TXLoaderCore.LOGGER.warn("Failed to move " + f.getName() + " to ./config/txloader/forceload/", (Throwable)e);
                }
            }
            try {
                oresources.delete();
            }
            catch (Exception e) {
                TXLoaderCore.LOGGER.warn("Failed to delete ./oresources/", (Throwable)e);
            }
        }
    }

    static {
        TYPE = new TypeToken<List<Asset>>(){
            private static final long serialVersionUID = 1L;
        }.getType();
    }
}

