/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft;

import com.pam.harvestcraft.ItemRegistry;
import com.pam.harvestcraft.PamUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;

public class OvenRecipes {
    private static final OvenRecipes smeltingBase = new OvenRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = new HashMap<ItemStack, ItemStack>();
    private final Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    private OvenRecipes() {
        this.addSmelting(Items.field_151147_al, new ItemStack(Items.field_151157_am), 0.1f);
        this.addSmelting(Items.field_151082_bd, new ItemStack(Items.field_151083_be), 0.1f);
        this.addSmelting(Items.field_151076_bf, new ItemStack(Items.field_151077_bg), 0.1f);
        this.addSmeltingRecipeForBlock(Blocks.field_150434_aF, new ItemStack(Items.field_151100_aR, 1, 2), 0.1f);
        this.addSmelting(Items.field_151174_bG, new ItemStack(Items.field_151168_bH), 0.1f);
        this.addSmelting(ItemRegistry.doughItem, new ItemStack(Items.field_151025_P, 1, 0), 0.1f);
        this.addSmelting(Items.field_151025_P, new ItemStack(ItemRegistry.toastItem, 1, 0), 0.1f);
        this.addSmelting(Items.field_151080_bb, new ItemStack(ItemRegistry.roastedpumpkinseedsItem, 1, 0), 0.1f);
        this.addSmeltingRecipeForBlock((Block)Blocks.field_150338_P, new ItemStack(ItemRegistry.grilledmushroomItem, 1, 0), 0.1f);
        this.addSmeltingRecipeForBlock((Block)Blocks.field_150337_Q, new ItemStack(ItemRegistry.grilledmushroomItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.muttonrawItem, new ItemStack(ItemRegistry.muttoncookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.calamarirawItem, new ItemStack(ItemRegistry.calamaricookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.turkeyrawItem, new ItemStack(ItemRegistry.turkeycookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.rabbitrawItem, new ItemStack(ItemRegistry.rabbitcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.venisonrawItem, new ItemStack(ItemRegistry.venisoncookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.asparagusItem, new ItemStack(ItemRegistry.grilledasparagusItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.riceItem, new ItemStack(ItemRegistry.ricecakeItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.tealeafItem, new ItemStack(ItemRegistry.teaItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.cornItem, new ItemStack(ItemRegistry.popcornItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.sweetpotatoItem, new ItemStack(ItemRegistry.bakedsweetpotatoItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.coffeebeanItem, new ItemStack(ItemRegistry.coffeeItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.eggplantItem, new ItemStack(ItemRegistry.grilledeggplantItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.grapeItem, new ItemStack(ItemRegistry.raisinsItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.whitemushroomItem, new ItemStack(ItemRegistry.grilledmushroomItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.coconutItem, new ItemStack(ItemRegistry.toastedcoconutItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.vanillabeanItem, new ItemStack(ItemRegistry.vanillaItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.chestnutItem, new ItemStack(ItemRegistry.roastedchestnutItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.sesameseedsItem, new ItemStack(ItemRegistry.toastedsesameseedsItem, 1, 0), 0.1f);
        for (ItemFishFood.FishType fishtype : ItemFishFood.FishType.values()) {
            if (!fishtype.func_150973_i()) continue;
            this.addSmeltingRecipe(new ItemStack(Items.field_151115_aP, 1, fishtype.func_150976_a()), new ItemStack(Items.field_151101_aQ, 1, fishtype.func_150976_a()), 0.35f);
        }
        this.addSmelting(ItemRegistry.anchovyrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.bassrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.carprawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.catfishrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.charrrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.eelrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.grouperrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.herringrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.mudfishrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.perchrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.snapperrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.tilapiarawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.troutrawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.tunarawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.walleyerawItem, new ItemStack(Items.field_151101_aQ, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.clamrawItem, new ItemStack(ItemRegistry.clamcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.crabrawItem, new ItemStack(ItemRegistry.crabcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.crayfishrawItem, new ItemStack(ItemRegistry.crayfishcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.frograwItem, new ItemStack(ItemRegistry.frogcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.octopusrawItem, new ItemStack(ItemRegistry.octopuscookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.scalloprawItem, new ItemStack(ItemRegistry.scallopcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.shrimprawItem, new ItemStack(ItemRegistry.shrimpcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.snailrawItem, new ItemStack(ItemRegistry.snailcookedItem, 1, 0), 0.1f);
        this.addSmelting(ItemRegistry.turtlerawItem, new ItemStack(ItemRegistry.turtlecookedItem, 1, 0), 0.1f);
        if (ItemRegistry.forcecookinginmeatrecipes) {
            for (int meta = 0; meta < ItemRegistry.mincedmeatrawItem.func_77612_l(); ++meta) {
                this.addSmelting(new ItemStack(ItemRegistry.mincedmeatrawItem, 1, meta).func_77973_b(), new ItemStack(ItemRegistry.mincedmeatcookedItem, 1, meta), 0.1f);
            }
        }
    }

    public static OvenRecipes smelting() {
        return smeltingBase;
    }

    public void addSmeltingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addSmelting(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addSmelting(Item input, ItemStack stack, float experience) {
        this.addSmeltingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addSmeltingRecipe(ItemStack input, ItemStack stack, float experience) {
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!PamUtils.areItemStacksEqualWithWildcard(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getSmeltingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!PamUtils.areItemStacksEqualWithWildcard(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

