/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram;

import codechicken.nei.NEIClientUtils;
import com.github.dcysteine.neicustomdiagram.api.draw.scroll.ScrollDirection;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;

public class DiagramState {
    public static final int TICKS_PER_CYCLE = 20;
    private int ticks = 0;

    public void tick() {
        if (ConfigOptions.CTRL_FAST_FORWARD.get().booleanValue() && NEIClientUtils.controlKey()) {
            this.ticks = NEIClientUtils.shiftKey() ? (this.ticks -= 20) : (this.ticks += 20);
        } else if (!NEIClientUtils.shiftKey()) {
            ++this.ticks;
        }
    }

    public void scroll(ScrollDirection direction) {
        this.ticks += direction.yFactor * 20;
    }

    public int ticks() {
        return this.ticks;
    }

    public int cycle() {
        return this.ticks / 20;
    }

    public int cycleIndex(int maxIndex) {
        return Math.floorMod(this.cycle(), maxIndex);
    }
}

