/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.debug;

import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.interfaces.IDebugHUDProvider;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.network.packets.routingdebug.RoutingUpdateCanidatePipe;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugCanidateList;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugClosedSet;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDebugFilters;
import logisticspipes.network.packets.routingdebug.RoutingUpdateDoneDebug;
import logisticspipes.network.packets.routingdebug.RoutingUpdateInitDebug;
import logisticspipes.network.packets.routingdebug.RoutingUpdateSourcePipe;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipefxhandlers.PipeFXRenderHandler;
import logisticspipes.renderer.LogisticsHUDRenderer;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.DebugWindow;
import logisticspipes.routing.debug.HUDRoutingTableDebugProvider;
import logisticspipes.routing.debug.HUDRoutingTableGeneralInfo;
import logisticspipes.utils.tuples.LPPosition;

public class ClientViewController
implements IDebugHUDProvider {
    private static ClientViewController instance;
    private LPPosition mainPipe = null;
    private int tick = 0;
    private final List<LPPosition> canidates = new ArrayList<LPPosition>();
    private DebugWindow debugWindow;
    private final List<IHeadUpDisplayRendererProvider> listHUD = new ArrayList<IHeadUpDisplayRendererProvider>();
    private final HashMap<LPPosition, DebugInformation> HUDPositions = new HashMap();

    private ClientViewController() {
    }

    public static ClientViewController instance() {
        if (instance == null) {
            instance = new ClientViewController();
        }
        return instance;
    }

    private DebugInformation getDebugInformation(LPPosition pos) {
        DebugInformation info = this.HUDPositions.get(pos);
        if (info == null) {
            info = new DebugInformation();
            this.HUDPositions.put(pos, info);
        }
        return info;
    }

    public void tick() {
        if (this.tick++ % 5 != 0) {
            return;
        }
        if (this.mainPipe != null) {
            PipeFXRenderHandler.spawnGenericParticle(Particles.WhiteParticle, this.mainPipe.getX(), this.mainPipe.getY(), this.mainPipe.getZ(), 1);
        }
        for (LPPosition pos : this.canidates) {
            PipeFXRenderHandler.spawnGenericParticle(Particles.OrangeParticle, pos.getX(), pos.getY(), pos.getZ(), 1);
        }
    }

    public void clear() {
        this.mainPipe = null;
        this.canidates.clear();
        this.listHUD.clear();
        this.HUDPositions.clear();
    }

    public void handlePacket(RoutingUpdateSourcePipe routingUpdateSourcePipe) {
        this.mainPipe = routingUpdateSourcePipe.getExitRoute().destination.getLPPosition();
        this.getDebugInformation((LPPosition)this.mainPipe).nextFlags = routingUpdateSourcePipe.getExitRoute().getFlags();
    }

    public void handlePacket(RoutingUpdateCanidatePipe routingUpdateCanidatePipe) {
        LPPosition pos = routingUpdateCanidatePipe.getExitRoute().destination.getLPPosition();
        this.canidates.add(routingUpdateCanidatePipe.getExitRoute().destination.getLPPosition());
        this.getDebugInformation((LPPosition)pos).isNew = true;
        this.getDebugInformation((LPPosition)pos).newIndex = routingUpdateCanidatePipe.getExitRoute().debug.index;
    }

    public void init(RoutingUpdateInitDebug routingUpdateInitDebug) {
        this.debugWindow = new DebugWindow("Debug Code", 500, 250);
        LogisticsHUDRenderer.instance().debugHUD = this;
    }

    public void done(RoutingUpdateDoneDebug routingUpdateDoneDebug) {
        if (this.debugWindow != null) {
            this.debugWindow.setVisible(false);
            this.debugWindow = null;
        }
        LogisticsHUDRenderer.instance().debugHUD = null;
        this.listHUD.clear();
        this.HUDPositions.clear();
    }

    public void handlePacket(RoutingUpdateDebugClosedSet routingUpdateDebugClosedSet) {
        this.getDebugInformation((LPPosition)routingUpdateDebugClosedSet.getPos()).closedSet = routingUpdateDebugClosedSet.getSet();
    }

    public void handlePacket(RoutingUpdateDebugFilters routingUpdateDebugFilters) {
        this.getDebugInformation((LPPosition)routingUpdateDebugFilters.getPos()).filters = routingUpdateDebugFilters.getFilterPositions();
    }

    public void updateList(RoutingUpdateDebugCanidateList routingUpdateDebugCanidateList) {
        this.debugWindow.clear();
        ExitRoute[] e = routingUpdateDebugCanidateList.getMsg();
        int i = 0;
        for (ExitRoute exit : e) {
            ++i;
            Color color = Color.BLACK;
            if (exit.debug.isNewlyAddedCanidate) {
                color = Color.BLUE;
            }
            this.debugWindow.showInfo(exit.destination.toString(), color);
            this.debugWindow.showInfo("\n", color);
            for (int j = 0; j < 2; ++j) {
                this.debugWindow.showInfo("\t", color);
            }
            this.debugWindow.showInfo(exit.debug.toStringNetwork, color);
            this.debugWindow.showInfo("\n", color);
            LPPosition pos = exit.destination.getLPPosition();
            this.getDebugInformation((LPPosition)pos).routes.add(exit);
            this.getDebugInformation((LPPosition)pos).positions.add(i);
        }
        for (Map.Entry entry : this.HUDPositions.entrySet()) {
            this.listHUD.add(new HUDRoutingTableDebugProvider(new HUDRoutingTableGeneralInfo((DebugInformation)entry.getValue()), (LPPosition)entry.getKey()));
        }
    }

    @Override
    public List<IHeadUpDisplayRendererProvider> getHUDs() {
        return this.listHUD;
    }

    public static class DebugInformation {
        public boolean isNew = false;
        public int newIndex = -1;
        public List<Integer> positions = new ArrayList<Integer>();
        public List<ExitRoute> routes = new ArrayList<ExitRoute>();
        public EnumSet<PipeRoutingConnectionType> closedSet;
        public EnumMap<PipeRoutingConnectionType, List<List<LPPosition>>> filters;
        public EnumSet<PipeRoutingConnectionType> nextFlags;
    }
}

