/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer.newpipe;

import java.util.HashMap;
import java.util.Map;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.CustomBlockRenderer;
import logisticspipes.renderer.FluidContainerRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class LogisticsNewPipeItemBoxRenderer {
    private static final int RENDER_SIZE = 40;
    private int renderList = -1;
    private static final ResourceLocation BLOCKS = new ResourceLocation("textures/atlas/blocks.png");
    private static final Map<FluidIdentifier, int[]> renderLists = new HashMap<FluidIdentifier, int[]>();

    public void doRenderItem(ItemStack itemstack, float light, double x, double y, double z, double boxScale) {
        FluidStack f;
        if (LogisticsNewRenderPipe.innerTransportBox == null) {
            return;
        }
        GL11.glPushMatrix();
        if (this.renderList == -1) {
            this.renderList = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.renderList, (int)4864);
            Tessellator tess = Tessellator.field_78398_a;
            tess.func_78382_b();
            LogisticsNewRenderPipe.innerTransportBox.render(LogisticsNewRenderPipe.innerBoxTexture);
            tess.func_78381_a();
            GL11.glEndList();
        }
        GL11.glTranslated((double)x, (double)y, (double)z);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BLOCKS);
        GL11.glScaled((double)boxScale, (double)boxScale, (double)boxScale);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        GL11.glCallList((int)this.renderList);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glScaled((double)(1.0 / boxScale), (double)(1.0 / boxScale), (double)(1.0 / boxScale));
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        if (itemstack != null && itemstack.func_77973_b() instanceof LogisticsFluidContainer && (f = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(ItemIdentifierStack.getFromStack(itemstack))) != null) {
            FluidContainerRenderer.skipNext = true;
            int list = this.getRenderListFor(f);
            GL11.glPushAttrib((int)8192);
            GL11.glEnable((int)2884);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glCallList((int)list);
            GL11.glPopAttrib();
        }
        GL11.glPopMatrix();
    }

    private int getRenderListFor(FluidStack fluid) {
        int pos;
        FluidIdentifier ident = FluidIdentifier.get(fluid);
        int[] array = renderLists.get(fluid);
        if (array == null) {
            array = new int[40];
            renderLists.put(ident, array);
        }
        if (array[pos = Math.min((int)((float)Math.min(fluid.amount, 5000) * 1.0f * 40.0f / 5000.0f), 39)] != 0) {
            return array[pos];
        }
        CustomBlockRenderer.RenderInfo block = new CustomBlockRenderer.RenderInfo();
        block.baseBlock = fluid.getFluid().getBlock();
        block.texture = fluid.getFluid().getStillIcon();
        float ratio = (float)pos * 1.0f / 39.0f;
        array[pos] = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)array[pos], (int)4864);
        block.minX = 0.32;
        block.maxX = 0.68;
        block.minY = 0.32;
        block.maxY = 0.32 + 0.36000000000000004 * (double)ratio;
        block.minZ = 0.32;
        block.maxZ = 0.68;
        CustomBlockRenderer.INSTANCE.renderBlock(block, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, 0, 0, 0, false, true);
        GL11.glEndList();
        return array[pos];
    }
}

