/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.packet;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import mods.battlegear2.Battlegear;
import mods.battlegear2.BattlemodeHookContainerClass;
import mods.battlegear2.BukkitWrapper;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.IInventoryPlayerBattle;
import mods.battlegear2.packet.AbstractMBPacket;
import mods.battlegear2.packet.BattlegearSyncItemPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public final class OffhandPlaceBlockPacket
extends AbstractMBPacket {
    public static final String packetName = "MB2|Place";
    private int xPosition;
    private int yPosition;
    private int zPosition;
    private int direction;
    private ItemStack itemStack;
    private float xOffset;
    private float yOffset;
    private float zOffset;

    public OffhandPlaceBlockPacket() {
    }

    public OffhandPlaceBlockPacket(int par1, int par2, int par3, int par4, ItemStack par5ItemStack, float par6, float par7, float par8) {
        this.xPosition = par1;
        this.yPosition = par2;
        this.zPosition = par3;
        this.direction = par4;
        this.itemStack = par5ItemStack != null ? par5ItemStack.func_77946_l() : null;
        this.xOffset = par6;
        this.yOffset = par7;
        this.zOffset = par8;
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void write(ByteBuf out) {
        out.writeInt(this.xPosition);
        out.writeByte(this.yPosition);
        out.writeInt(this.zPosition);
        out.writeByte(this.direction);
        ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.itemStack);
        out.writeByte((int)(this.xOffset * 16.0f));
        out.writeByte((int)(this.yOffset * 16.0f));
        out.writeByte((int)(this.zOffset * 16.0f));
    }

    @Override
    public void process(ByteBuf in, EntityPlayer player) {
        try {
            this.xPosition = in.readInt();
            this.yPosition = in.readUnsignedByte();
            this.zPosition = in.readInt();
            this.direction = in.readUnsignedByte();
            this.itemStack = ByteBufUtils.readItemStack((ByteBuf)in);
            this.xOffset = (float)in.readUnsignedByte() / 16.0f;
            this.yOffset = (float)in.readUnsignedByte() / 16.0f;
            this.zOffset = (float)in.readUnsignedByte() / 16.0f;
        }
        catch (Exception io) {
            return;
        }
        if (player == null || !(player instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack offhandWeapon = ((IInventoryPlayerBattle)player.field_71071_by).battlegear2$getCurrentOffhandWeapon();
        boolean flag = true;
        int i = this.xPosition;
        int j = this.yPosition;
        int k = this.zPosition;
        int l = this.direction;
        ((EntityPlayerMP)player).func_143004_u();
        if (this.direction == 255) {
            if (offhandWeapon == null) {
                return;
            }
            PlayerInteractEvent event = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_AIR, 0, 0, 0, -1, player.func_130014_f_());
            BukkitWrapper.callBukkitInteractEvent(event, offhandWeapon);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.UseOffhandItemEvent(event, offhandWeapon));
            if (event.useItem != Event.Result.DENY) {
                BattlegearUtils.refreshAttributes(player, false);
                BattlemodeHookContainerClass.tryUseItem(player, offhandWeapon, Side.SERVER);
                BattlegearUtils.refreshAttributes(player, true);
            }
            flag = false;
        } else {
            MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (this.yPosition >= mcServer.func_71207_Z() - 1 && (this.direction == 1 || this.yPosition >= mcServer.func_71207_Z())) {
                ChatComponentTranslation chat = new ChatComponentTranslation("build.tooHigh", new Object[]{mcServer.func_71207_Z()});
                chat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S02PacketChat((IChatComponent)chat));
            } else {
                double dist = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0;
                dist *= dist;
                if (((EntityPlayerMP)player).field_71135_a.field_147380_r && player.func_70092_e((double)i + 0.5, (double)j + 0.5, (double)k + 0.5) < dist && !mcServer.func_96290_a(player.func_130014_f_(), i, j, k, player)) {
                    this.activateBlockOrUseItem((EntityPlayerMP)player, offhandWeapon, i, j, k, l, this.xOffset, this.yOffset, this.zOffset);
                }
            }
        }
        if (flag) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(i, j, k, player.func_130014_f_()));
            if (l == 0) {
                --j;
            }
            if (l == 1) {
                ++j;
            }
            if (l == 2) {
                --k;
            }
            if (l == 3) {
                ++k;
            }
            if (l == 4) {
                --i;
            }
            if (l == 5) {
                ++i;
            }
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(i, j, k, player.func_130014_f_()));
        }
        if ((offhandWeapon = ((IInventoryPlayerBattle)player.field_71071_by).battlegear2$getCurrentOffhandWeapon()) != null && offhandWeapon.field_77994_a <= 0) {
            BattlegearUtils.setPlayerOffhandItem(player, null);
            offhandWeapon = null;
        }
        if (offhandWeapon == null || offhandWeapon.func_77988_m() == 0) {
            ((EntityPlayerMP)player).field_71137_h = true;
            BattlegearUtils.setPlayerOffhandItem(player, ItemStack.func_77944_b((ItemStack)((IInventoryPlayerBattle)player.field_71071_by).battlegear2$getCurrentOffhandWeapon()));
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).field_71137_h = false;
            if (!ItemStack.func_77989_b((ItemStack)((IInventoryPlayerBattle)player.field_71071_by).battlegear2$getCurrentOffhandWeapon(), (ItemStack)this.itemStack)) {
                Battlegear.packetHandler.sendPacketToPlayer(new BattlegearSyncItemPacket(player).generatePacket(), (EntityPlayerMP)player);
            }
        }
    }

    public boolean activateBlockOrUseItem(EntityPlayerMP playerMP, ItemStack itemStack, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        boolean useBlock;
        World theWorld = playerMP.func_130014_f_();
        PlayerInteractEvent event = new PlayerInteractEvent((EntityPlayer)playerMP, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, x, y, z, side, theWorld);
        BukkitWrapper.callBukkitInteractEvent(event, itemStack);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.UseOffhandItemEvent(event, itemStack));
        if (event.isCanceled()) {
            playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, theWorld));
            return false;
        }
        BattlegearUtils.refreshAttributes((EntityPlayer)playerMP, false);
        if (itemStack != null && itemStack.func_77973_b().onItemUseFirst(itemStack, (EntityPlayer)playerMP, theWorld, x, y, z, side, xOffset, yOffset, zOffset)) {
            if (itemStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)playerMP, (ItemStack)itemStack);
            }
            BattlegearUtils.refreshAttributes((EntityPlayer)playerMP, true);
            return true;
        }
        boolean bl = useBlock = !playerMP.func_70093_af() || playerMP.func_70694_bm() == null;
        if (!useBlock) {
            useBlock = playerMP.func_70694_bm().func_77973_b().doesSneakBypassUse(theWorld, x, y, z, (EntityPlayer)playerMP);
        }
        boolean result = false;
        if (useBlock) {
            if (event.useBlock != Event.Result.DENY) {
                result = theWorld.func_147439_a(x, y, z).func_149727_a(theWorld, x, y, z, (EntityPlayer)playerMP, side, xOffset, yOffset, zOffset);
            } else {
                playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, theWorld));
                boolean bl2 = result = event.useItem != Event.Result.ALLOW;
            }
        }
        if (itemStack != null && !result && event.useItem != Event.Result.DENY) {
            int meta = itemStack.func_77960_j();
            int size = itemStack.field_77994_a;
            result = itemStack.func_77943_a((EntityPlayer)playerMP, theWorld, x, y, z, side, xOffset, yOffset, zOffset);
            if (playerMP.field_71134_c.func_73083_d()) {
                itemStack.func_77964_b(meta);
                itemStack.field_77994_a = size;
            }
            if (itemStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)playerMP, (ItemStack)itemStack);
            }
        }
        BattlegearUtils.refreshAttributes((EntityPlayer)playerMP, true);
        return result;
    }
}

