/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.gui;

import mods.battlegear2.Battlegear;
import mods.battlegear2.api.heraldry.HeraldryData;
import mods.battlegear2.api.heraldry.RefreshableTexture;
import mods.battlegear2.client.BattlegearClientEvents;
import mods.battlegear2.client.gui.controls.GUICrestElementList;
import mods.battlegear2.client.gui.controls.GuiColourPicker;
import mods.battlegear2.client.gui.controls.GuiColourToggleButton;
import mods.battlegear2.client.gui.controls.GuiPatternScrollList;
import mods.battlegear2.client.gui.controls.GuiToggleButton;
import mods.battlegear2.client.gui.controls.IControlListener;
import mods.battlegear2.client.renderer.HeraldryCrestItemRenderer;
import mods.battlegear2.gui.ContainerHeraldry;
import mods.battlegear2.packet.BattlegearGUIPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class BattlegearSigilGUI
extends GuiContainer {
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int PATTERN = 2;
    private static final int PAT_COL_1 = 3;
    private static final int PAT_COL_2 = 4;
    private static final int PAT_COL_3 = 5;
    private static final int COL_SELECT_PAT = 6;
    private static final int[] PAT_BUTTONS = new int[]{2, 3, 4, 5};
    private static int RES = 32;
    private GUICrestElementList elementList;
    private int selectedIndex;
    private HeraldryData currentData = HeraldryData.getDefault();
    private GuiButton addButton;
    private GuiButton removeButton;
    private GuiToggleButton[] patternToggleButtons;
    private GuiColourPicker colourPickerPattern;
    private GuiPatternScrollList scrollListPattern;
    private final RefreshableTexture currentCrest = new RefreshableTexture(RES, RES);
    private boolean crestDirty = true;

    public BattlegearSigilGUI(EntityPlayer entityPlayer, boolean isRemote) {
        super((Container)new ContainerHeraldry(entityPlayer.field_71071_by, !isRemote, entityPlayer));
    }

    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.elementList = new GUICrestElementList(this, 125, (this.field_146294_l - 125) / 2);
        this.addButton = new GuiButton(0, (this.field_146294_l - 125) / 2 + 2, 5, 60, 20, StatCollector.func_74838_a((String)"gui.sigil.add"));
        this.removeButton = new GuiButton(1, (this.field_146294_l - 125) / 2 + 63, 5, 60, 20, StatCollector.func_74838_a((String)"gui.sigil.remove"));
        this.field_146292_n.add(this.addButton);
        this.field_146292_n.add(this.removeButton);
        this.addButton.field_146124_l = this.elementList.getSize() < 7;
        this.removeButton.field_146124_l = this.selectedIndex != 0;
        this.patternToggleButtons = new GuiToggleButton[PAT_BUTTONS.length];
        int prevIndexSelected = 0;
        for (i = 0; i < this.patternToggleButtons.length; ++i) {
            if (this.patternToggleButtons[i] == null || !this.patternToggleButtons[i].getSelected()) continue;
            prevIndexSelected = i;
        }
        this.patternToggleButtons[0] = new GuiToggleButton(PAT_BUTTONS[0], (this.field_146294_l + 160) / 2, 15, 65, 20, StatCollector.func_74838_a((String)"gui.sigil.pattern"));
        this.patternToggleButtons[0].field_146124_l = this.selectedIndex == 0;
        this.patternToggleButtons[0].field_146125_m = this.selectedIndex == 0;
        this.field_146292_n.add(this.patternToggleButtons[0]);
        for (i = 1; i < this.patternToggleButtons.length; ++i) {
            this.patternToggleButtons[i] = new GuiColourToggleButton(PAT_BUTTONS[i], (this.field_146294_l + 160) / 2 + 66 + 16 * (i - 1), 18, this.currentData.getColour(i - 1));
            this.patternToggleButtons[i].field_146124_l = this.selectedIndex == 0;
            this.patternToggleButtons[i].field_146125_m = this.selectedIndex == 0;
            this.field_146292_n.add(this.patternToggleButtons[i]);
        }
        this.patternToggleButtons[prevIndexSelected].setSelected(true);
        this.colourPickerPattern = new GuiColourPicker(6, (this.field_146294_l + 200) / 2, 45, -16777216, 5);
        this.colourPickerPattern.field_146124_l = this.selectedIndex == 0 && !this.patternToggleButtons[0].getSelected();
        this.colourPickerPattern.field_146125_m = this.colourPickerPattern.field_146124_l;
        this.colourPickerPattern.addListener(new IControlListener(){

            @Override
            public void actionPreformed(GuiButton button) {
                int selectedToggle = 1;
                for (int i = 1; i < BattlegearSigilGUI.this.patternToggleButtons.length; ++i) {
                    if (!BattlegearSigilGUI.this.patternToggleButtons[i].getSelected()) continue;
                    selectedToggle = i;
                }
                ((GuiColourToggleButton)BattlegearSigilGUI.this.patternToggleButtons[selectedToggle]).setColour(BattlegearSigilGUI.this.colourPickerPattern.getRGB());
                BattlegearSigilGUI.this.currentData.setColour(selectedToggle - 1, BattlegearSigilGUI.this.colourPickerPattern.getRGB());
                BattlegearSigilGUI.this.elementList.markDirty(0);
                BattlegearSigilGUI.this.crestDirty = true;
            }
        });
        this.field_146292_n.add(this.colourPickerPattern);
        this.scrollListPattern = new GuiPatternScrollList(this, 125, 45, this.field_146295_m - 32, (this.field_146294_l + 160) / 2);
        BattlegearClientEvents.onOpenGui(this.field_146292_n, this.field_147003_i - 100, 5);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    private void enableButtons() {
        this.removeButton.field_146124_l = this.selectedIndex != 0;
        for (int i = 0; i < this.patternToggleButtons.length; ++i) {
            this.patternToggleButtons[i].field_146124_l = this.selectedIndex == 0;
            this.patternToggleButtons[i].field_146125_m = this.selectedIndex == 0;
        }
        this.colourPickerPattern.field_146124_l = this.colourPickerPattern.field_146125_m = this.selectedIndex == 0 & !this.patternToggleButtons[0].getSelected();
        this.addButton.field_146124_l = this.elementList.getSize() < 7;
        this.scrollListPattern.drawList = this.selectedIndex == 0 & this.patternToggleButtons[0].getSelected();
    }

    public void select(int index) {
        this.selectedIndex = index;
        this.enableButtons();
        this.crestDirty = true;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        if (this.elementList != null) {
            this.elementList.drawScreen(par1, par2, par3);
        }
        if (this.scrollListPattern != null) {
            this.scrollListPattern.drawScreen(par1, par2, par3);
        }
        this.drawButtonControlPanel();
        super.func_73863_a(par1, par2, par3);
        this.drawCrest();
    }

    protected void func_146976_a(float f, int i, int j) {
    }

    private void drawButtonControlPanel() {
        BattlegearSigilGUI.func_73734_a((int)((this.field_146294_l + 150) / 2), (int)0, (int)((this.field_146294_l + 400) / 2), (int)this.field_146295_m, (int)0x44000000);
    }

    public HeraldryData getCurrentData() {
        return this.currentData;
    }

    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        this.crestDirty = true;
        switch (button.field_146127_k) {
            case 0: {
                this.elementList.addNewCrest();
                break;
            }
            case 1: {
                this.elementList.removeCrest(this.selectedIndex);
                this.select(this.selectedIndex - 1);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                for (int i = 0; i < this.patternToggleButtons.length; ++i) {
                    this.patternToggleButtons[i].setSelected(button.field_146127_k == this.patternToggleButtons[i].field_146127_k);
                }
                this.colourPickerPattern.field_146125_m = button.field_146127_k != 2;
                boolean bl = this.colourPickerPattern.field_146124_l = button.field_146127_k != 2;
                if (button.field_146127_k == 2) break;
                this.colourPickerPattern.selectColour(((GuiColourToggleButton)button).getColour());
                break;
            }
        }
        this.enableButtons();
    }

    public void markAllDirty() {
        for (int i = 0; i < 7; ++i) {
            this.elementList.markDirty(i);
        }
        this.scrollListPattern.markAllDirty();
        this.crestDirty = true;
    }

    private void drawCrest() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(HeraldryCrestItemRenderer.map_overlay);
        this.drawTexturedModalRect((this.field_146294_l - 400) / 2, 50, 128, 128, 0, 0, 1, 1);
        if (this.crestDirty) {
            this.currentCrest.refreshWith(this.currentData, true);
            this.crestDirty = false;
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glDisable((int)3008);
        this.currentCrest.func_110564_a();
        ResourceLocation rl = Minecraft.func_71410_x().func_110434_K().func_110578_a("gui_crest", (DynamicTexture)this.currentCrest);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
        this.drawTexturedModalRect((this.field_146294_l - 400) / 2 + 16, 66, 96, 96, 0, 0, 1, 1);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
    }

    public void drawTexturedModalRect(int x, int y, int width, int height, int tex_x, int tex_y, int tex_width, int tex_height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)(tex_x + 0), (double)(tex_y + tex_height));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)(tex_x + tex_width), (double)(tex_y + tex_height));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)(tex_x + tex_width), (double)(tex_y + 0));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)(tex_x + 0), (double)(tex_y + 0));
        tessellator.func_78381_a();
    }

    public static void open(EntityPlayer player) {
        Battlegear.packetHandler.sendPacketToServer(new BattlegearGUIPacket(2).generatePacket());
    }
}

