/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import cpw.mods.fml.common.IWorldGenerator;
import gcewing.sg.BaseConfiguration;
import gcewing.sg.SGChunkData;
import gcewing.sg.SGCraft;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class NaquadahOreWorldGen
implements IWorldGenerator {
    static int genUnderLavaOdds = 4;
    static int maxNodesUnderLava = 8;
    static int genIsolatedOdds = 8;
    static int maxIsolatedNodes = 4;
    static boolean debugLava = false;
    static boolean debugRandom = false;
    static int debugLevel = 0;
    Random random;
    World world;
    Chunk chunk;
    int x0;
    int z0;
    Block stone = Blocks.field_150348_b;
    Block lava = Blocks.field_150353_l;
    Block naquadah = SGCraft.naquadahOre;

    public static void configure(BaseConfiguration cfg) {
        genUnderLavaOdds = cfg.getInteger("naquadah", "genUnderLavaOdds", genUnderLavaOdds);
        maxNodesUnderLava = cfg.getInteger("naquadah", "maxNodesUnderLava", maxNodesUnderLava);
        genIsolatedOdds = cfg.getInteger("naquadah", "genIsolatedOdds", genIsolatedOdds);
        maxIsolatedNodes = cfg.getInteger("naquadah", "maxIsolatedNodes", maxIsolatedNodes);
        debugLava = cfg.getBoolean("naquadah", "debugLava", debugLava);
        debugRandom = cfg.getBoolean("naquadah", "debugRandom", debugRandom);
        debugLevel = cfg.getInteger("naquadah", "debugLevel", debugLevel);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        this.random = random;
        this.world = world;
        this.x0 = chunkX * 16;
        this.z0 = chunkZ * 16;
        this.chunk = world.func_72964_e(chunkX, chunkZ);
        this.generateChunk();
    }

    public void regenerate(Chunk chunk) {
        this.chunk = chunk;
        this.world = chunk.field_76637_e;
        int chunkX = chunk.field_76635_g;
        int chunkZ = chunk.field_76647_h;
        long worldSeed = this.world.func_72905_C();
        this.random = new Random(worldSeed);
        long xSeed = this.random.nextLong() >> 3;
        long zSeed = this.random.nextLong() >> 3;
        this.random.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        this.x0 = chunkX * 16;
        this.z0 = chunkZ * 16;
        this.generateChunk();
    }

    Block getBlock(int x, int y, int z) {
        return this.chunk.func_150810_a(x, y, z);
    }

    void setBlock(int x, int y, int z, Block id) {
        this.chunk.func_150807_a(x, y, z, id, 0);
    }

    void generateNode(Block id, int x, int y, int z, int sx, int sy, int sz) {
        int dx = this.random.nextInt(sx);
        int dy = this.random.nextInt(sy);
        int dz = this.random.nextInt(sz);
        int h = this.world.func_72800_K();
        if (debugRandom && debugLevel >= 1) {
            SGCraft.log.debug(String.format("NaquadahOreWorldGen: %d x %d x %d node at (%d, %d, %d)", dx + 1, dy + 1, dz + 1, this.x0 + x, y, this.z0 + z));
        }
        for (int i = x; i <= x + dx; ++i) {
            for (int j = y; j <= y + dy; ++j) {
                for (int k = z; k <= z + dz; ++k) {
                    if (i >= 16 || j >= h || k >= 16 || this.getBlock(i, j, k) != this.stone) continue;
                    if (debugRandom && debugLevel >= 2) {
                        SGCraft.log.debug(String.format("NaquadahOreWorldGen: block at (%d, %d, %d)", this.x0 + i, j, this.z0 + k));
                    }
                    this.setBlock(i, j, k, id);
                }
            }
        }
    }

    boolean odds(int n) {
        return this.random.nextInt(n) == 0;
    }

    void generateChunk() {
        int x;
        int i;
        int n;
        SGChunkData.forChunk((Chunk)this.chunk).oresGenerated = true;
        if (this.odds(genUnderLavaOdds)) {
            n = this.random.nextInt(maxNodesUnderLava) + 1;
            for (i = 0; i < n; ++i) {
                x = this.random.nextInt(16);
                int z = this.random.nextInt(16);
                for (int y = 0; y < 64; ++y) {
                    if (this.getBlock(x, y, z) != this.stone || this.getBlock(x, y + 1, z) != this.lava) continue;
                    if (debugLava) {
                        SGCraft.log.debug(String.format("NaquadahOreWorldGen: generating under lava at (%d, %d, %d)", this.x0 + x, y, this.z0 + z));
                    }
                    this.generateNode(this.naquadah, x, y, z, 3, 1, 3);
                }
            }
        }
        if (this.odds(genIsolatedOdds)) {
            n = this.random.nextInt(maxIsolatedNodes) + 1;
            for (i = 0; i < n; ++i) {
                int z;
                int y;
                x = this.random.nextInt(16);
                if (this.getBlock(x, y = this.random.nextInt(64), z = this.random.nextInt(16)) != this.stone) continue;
                if (debugRandom) {
                    SGCraft.log.debug(String.format("NaquadahOreWorldGen: generating randomly at (%d, %d, %d)", this.x0 + x, y, this.z0 + z));
                }
                this.generateNode(this.naquadah, x, y, z, 2, 2, 2);
            }
        }
    }
}

