/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.misc;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;

public class Game {
    public static final boolean IS_OBFUSCATED = !World.class.getSimpleName().equals("World");
    public static final boolean IS_DEBUG = !"9.15.2".endsWith("0");
    public static final boolean IS_BUKKIT;
    public static final Logger LOGGER;
    public static boolean isGTNH;

    public static boolean isHost(World world) {
        return !world.field_72995_K;
    }

    public static boolean isNotHost(World world) {
        return world.field_72995_K;
    }

    @SideOnly(value=Side.CLIENT)
    public static World getWorld() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null) {
            return mc.field_71441_e;
        }
        return null;
    }

    public static boolean isObfuscated() {
        return IS_OBFUSCATED;
    }

    public static void log(Level level, String msg, Object ... args) {
        if (msg != null) {
            Game.log(level, (Message)new MessageFormatMessage(msg, args));
        }
    }

    public static void log(Level level, Message msg) {
        LOGGER.log(level, msg);
    }

    public static void logTrace(Level level, String msg, Object ... args) {
        Game.logTrace(level, 5, msg, args);
    }

    public static void logTrace(Level level, int lines, String msg, Object ... args) {
        Game.log(level, msg, args);
        Game.logTrace(level, lines, 2, Thread.currentThread().getStackTrace());
    }

    public static void logTrace(Level level, int lines, int skipLines, StackTraceElement[] stackTrace) {
        for (int i = skipLines; i < stackTrace.length && i < skipLines + lines; ++i) {
            Game.log(level, stackTrace[i].toString(), new Object[0]);
        }
    }

    public static void logThrowable(String msg, Throwable error, Object ... args) {
        Game.logThrowable(Level.ERROR, msg, 3, error, args);
    }

    public static void logThrowable(String msg, int lines, Throwable error, Object ... args) {
        Game.logThrowable(Level.ERROR, msg, lines, error, args);
    }

    public static void logThrowable(Level level, String msg, int lines, Throwable error, Object ... args) {
        Game.log(level, msg, args);
        if (error.getMessage() != null) {
            Game.log(level, error.getMessage(), new Object[0]);
        }
        Game.logTrace(level, lines, 0, error.getStackTrace());
    }

    public static void logDebug(String msg, Object ... args) {
        if (!IS_DEBUG) {
            return;
        }
        Game.log(Level.DEBUG, msg, args);
    }

    public static void logErrorAPI(String mod, Throwable error, Class ... classFiles) {
        StringBuilder msg = new StringBuilder(mod);
        msg.append(" API error, please update your mods. Error: ").append(error);
        Game.logThrowable(Level.ERROR, msg.toString(), 2, error, new Object[0]);
        for (Class classFile : classFiles) {
            if (classFile == null) continue;
            msg = new StringBuilder(mod);
            msg.append(" API error: ").append(classFile.getSimpleName()).append(" is loaded from ").append(classFile.getProtectionDomain().getCodeSource().getLocation());
            Game.log(Level.ERROR, msg.toString(), new Object[0]);
        }
    }

    public static void logErrorFingerprint(String mod) {
        Game.log(Level.FATAL, "{0} failed validation, terminating. Please re-download {0} from an official source.", new Object[0]);
    }

    static {
        LOGGER = LogManager.getLogger((String)"Railcraft");
        boolean foundBukkit = false;
        try {
            foundBukkit = Class.forName("org.spigotmc.SpigotConfig") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        IS_BUKKIT = foundBukkit;
        if (IS_BUKKIT) {
            Game.log(Level.INFO, "Bukkit detected, disabling Tile Entity caching because Bukkit doesn't seem to invalid Tile Entities properly!", new Object[0]);
        }
    }
}

