/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import java.util.EnumSet;
import mods.railcraft.api.electricity.GridTools;
import mods.railcraft.api.electricity.IElectricGrid;
import mods.railcraft.client.render.BlockRenderer;
import mods.railcraft.client.render.MatrixTransformations;
import mods.railcraft.client.render.RenderBlockFrame;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.frame.BlockFrame;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.delta.TileWire;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockMachineDelta
extends BlockRenderer {
    public RenderBlockMachineDelta() {
        super(RailcraftBlocks.getBlockMachineDelta());
        this.addCombinedRenderer(EnumMachineDelta.WIRE.ordinal(), new WireRenderer());
        this.addBlockRenderer(EnumMachineDelta.CAGE.ordinal(), new CageRenderer());
    }

    private class CageRenderer
    extends BlockRenderer.DefaultRenderer {
        private CageRenderer() {
            super(RenderBlockMachineDelta.this);
        }

        @Override
        public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            double[][] vertices;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78380_c(block.func_149677_c(world, x, y, z));
            float c = 1.0f;
            tessellator.func_78386_a(c, c, c);
            IIcon icon = renderblocks.func_147793_a(block, world, x, y, z, 2);
            if (renderblocks.func_147744_b()) {
                icon = renderblocks.field_147840_d;
            }
            double minU = icon.func_94209_e();
            double minV = icon.func_94206_g();
            double maxU = icon.func_94212_f();
            double maxV = icon.func_94210_h();
            double border = 0.0;
            double offset = 0.001;
            if (WorldPlugin.getBlock(world, x - 1, y, z) != block || world.func_72805_g(x - 1, y, z) != EnumMachineDelta.CAGE.ordinal()) {
                vertices = new double[][]{{(double)x + offset, (double)(y + 1) + border, (double)(z + 1) + border, minU, minV}, {(double)x + offset, (double)(y + 0) - border, (double)(z + 1) + border, minU, maxV}, {(double)x + offset, (double)(y + 0) - border, (double)(z + 0) - border, maxU, maxV}, {(double)x + offset, (double)(y + 1) + border, (double)(z + 0) - border, maxU, minV}};
                this.renderFace(tessellator, vertices);
            }
            if (WorldPlugin.getBlock(world, x + 1, y, z) != block || world.func_72805_g(x + 1, y, z) != EnumMachineDelta.CAGE.ordinal()) {
                vertices = new double[][]{{(double)(x + 1) - offset, (double)(y + 0) - border, (double)(z + 1) + border, maxU, maxV}, {(double)(x + 1) - offset, (double)(y + 1) + border, (double)(z + 1) + border, maxU, minV}, {(double)(x + 1) - offset, (double)(y + 1) + border, (double)(z + 0) - border, minU, minV}, {(double)(x + 1) - offset, (double)(y + 0) - border, (double)(z + 0) - border, minU, maxV}};
                this.renderFace(tessellator, vertices);
            }
            if (WorldPlugin.getBlock(world, x, y, z - 1) != block || world.func_72805_g(x, y, z - 1) != EnumMachineDelta.CAGE.ordinal()) {
                vertices = new double[][]{{(double)(x + 1) + border, (double)(y + 0) - border, (double)z + offset, maxU, maxV}, {(double)(x + 1) + border, (double)(y + 1) + border, (double)z + offset, maxU, minV}, {(double)(x + 0) - border, (double)(y + 1) + border, (double)z + offset, minU, minV}, {(double)(x + 0) - border, (double)(y + 0) - border, (double)z + offset, minU, maxV}};
                this.renderFace(tessellator, vertices);
            }
            if (WorldPlugin.getBlock(world, x, y, z + 1) != block || world.func_72805_g(x, y, z + 1) != EnumMachineDelta.CAGE.ordinal()) {
                vertices = new double[][]{{(double)(x + 1) + border, (double)(y + 1) + border, (double)(z + 1) - offset, minU, minV}, {(double)(x + 1) + border, (double)(y + 0) - border, (double)(z + 1) - offset, minU, maxV}, {(double)(x + 0) - border, (double)(y + 0) - border, (double)(z + 1) - offset, maxU, maxV}, {(double)(x + 0) - border, (double)(y + 1) + border, (double)(z + 1) - offset, maxU, minV}};
                this.renderFace(tessellator, vertices);
            }
            if (WorldPlugin.getBlock(world, x, y - 1, z) != block || world.func_72805_g(x, y - 1, z) != EnumMachineDelta.CAGE.ordinal()) {
                icon = renderblocks.func_147793_a(block, world, x, y, z, 0);
                if (renderblocks.func_147744_b()) {
                    icon = renderblocks.field_147840_d;
                }
                minU = icon.func_94209_e();
                minV = icon.func_94206_g();
                maxU = icon.func_94212_f();
                maxV = icon.func_94210_h();
                vertices = new double[][]{{(double)(x + 1) + border, (double)y + offset, (double)(z + 1) + border, minU, minV}, {(double)(x + 0) - border, (double)y + offset, (double)(z + 1) + border, minU, maxV}, {(double)(x + 0) - border, (double)y + offset, (double)(z + 0) - border, maxU, maxV}, {(double)(x + 1) + border, (double)y + offset, (double)(z + 0) - border, maxU, minV}};
                this.renderFace(tessellator, vertices);
            }
            if (WorldPlugin.getBlock(world, x, y + 1, z) != block || world.func_72805_g(x, y + 1, z) != EnumMachineDelta.CAGE.ordinal()) {
                icon = renderblocks.func_147793_a(block, world, x, y, z, 1);
                if (renderblocks.func_147744_b()) {
                    icon = renderblocks.field_147840_d;
                }
                minU = icon.func_94209_e();
                minV = icon.func_94206_g();
                maxU = icon.func_94212_f();
                maxV = icon.func_94210_h();
                vertices = new double[][]{{(double)(x + 0) - border, (double)(y + 1) - offset, (double)(z + 1) + border, maxU, maxV}, {(double)(x + 1) + border, (double)(y + 1) - offset, (double)(z + 1) + border, maxU, minV}, {(double)(x + 1) + border, (double)(y + 1) - offset, (double)(z + 0) - border, minU, minV}, {(double)(x + 0) - border, (double)(y + 1) - offset, (double)(z + 0) - border, minU, maxV}};
                this.renderFace(tessellator, vertices);
            }
        }

        private void renderFace(Tessellator tess, double[][] vertices) {
            int i;
            for (i = 0; i < 4; ++i) {
                tess.func_78374_a(vertices[i][0], vertices[i][1], vertices[i][2], vertices[i][3], vertices[i][4]);
            }
            for (i = 0; i < 4; ++i) {
                tess.func_78374_a(vertices[3 - i][0], vertices[3 - i][1], vertices[3 - i][2], vertices[i][3], vertices[i][4]);
            }
        }
    }

    private class WireRenderer
    extends BlockRenderer.DefaultRenderer {
        private final RenderBlockFrame renderFrame;
        private RenderFakeBlock.RenderInfo info;

        public WireRenderer() {
            super(RenderBlockMachineDelta.this);
            this.info = new RenderFakeBlock.RenderInfo();
            this.renderFrame = BlockFrame.getBlock() != null ? new RenderBlockFrame() : null;
            this.info.template = RenderBlockMachineDelta.this.getBlock();
        }

        @Override
        public void renderBlock(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            TileWire wire;
            TileEntity tile;
            EnumSet<ForgeDirection> wireCons = EnumSet.noneOf(ForgeDirection.class);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                tile = WorldPlugin.getTileEntityOnSide(world, x, y, z, dir);
                if (!(tile instanceof TileWire)) continue;
                wireCons.add(dir);
            }
            EnumSet<ForgeDirection> plugCons = EnumSet.noneOf(ForgeDirection.class);
            EnumSet<ForgeDirection> search = EnumSet.allOf(ForgeDirection.class);
            search.remove(ForgeDirection.UNKNOWN);
            search.removeAll(wireCons);
            for (ForgeDirection dir : search) {
                tile = WorldPlugin.getTileEntityOnSide(world, x, y, z, dir);
                if (!(tile instanceof IElectricGrid) || ((IElectricGrid)tile).getChargeHandler().getType() != IElectricGrid.ChargeHandler.ConnectType.BLOCK) continue;
                plugCons.add(dir);
            }
            wireCons.addAll(plugCons);
            boolean powered = false;
            IElectricGrid above = GridTools.getGridObjectAt(world, x, y + 1, z);
            if (above != null && TrackTools.isRailBlockAt(world, x, y + 1, z)) {
                wireCons.add(ForgeDirection.UP);
                plugCons.add(ForgeDirection.UP);
                powered = true;
            }
            this.renderWire(renderblocks, world, x, y, z, block, wireCons);
            this.renderPlug(renderblocks, world, x, y, z, block, plugCons);
            tile = WorldPlugin.getBlockTile(world, x, y, z);
            if (tile instanceof TileWire && (wire = (TileWire)tile).getAddon() == TileWire.AddonType.FRAME) {
                BlockFrame.poweredTexture = powered;
                this.renderFrame(renderblocks, world, x, y, z, block);
                BlockFrame.poweredTexture = false;
            }
            block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }

        private void renderFrame(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            if (this.renderFrame != null) {
                this.renderFrame.renderWorldBlock(world, x, y, z, BlockFrame.getBlock(), BlockFrame.getBlock().func_149645_b(), renderblocks);
            }
        }

        private void renderPlatform(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block) {
            block.func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
            RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
        }

        private void renderWire(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block, EnumSet<ForgeDirection> wireCons) {
            float pix = 0.0625f;
            float max = 0.999f;
            float min = 0.001f;
            if (wireCons.isEmpty()) {
                block.func_149676_a(6.0f * pix, 6.0f * pix, 6.0f * pix, 10.0f * pix, 10.0f * pix, 10.0f * pix);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
                block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
            boolean down = wireCons.contains(ForgeDirection.DOWN);
            boolean up = wireCons.contains(ForgeDirection.UP);
            if (down || up) {
                block.func_149676_a(6.0f * pix, down ? min : 6.0f * pix, 6.0f * pix, 10.0f * pix, up ? max : 10.0f * pix, 10.0f * pix);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            boolean north = wireCons.contains(ForgeDirection.NORTH);
            boolean south = wireCons.contains(ForgeDirection.SOUTH);
            if (north || south) {
                block.func_149676_a(6.0f * pix - 1.0E-4f, 6.0f * pix - 1.0E-4f, north ? min : 6.0f * pix - 1.0E-4f, 10.0f * pix + 1.0E-4f, 10.0f * pix + 1.0E-4f, south ? max : 10.0f * pix + 1.0E-4f);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
            boolean west = wireCons.contains(ForgeDirection.WEST);
            boolean east = wireCons.contains(ForgeDirection.EAST);
            if (west || east) {
                block.func_149676_a(west ? min : 6.0f * pix - 2.0E-4f, 6.0f * pix - 2.0E-4f, 6.0f * pix - 2.0E-4f, east ? max : 10.0f * pix + 2.0E-4f, 10.0f * pix + 2.0E-4f, 10.0f * pix + 2.0E-4f);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
        }

        private void renderPlug(RenderBlocks renderblocks, IBlockAccess world, int x, int y, int z, Block block, EnumSet<ForgeDirection> plugCons) {
            if (plugCons.isEmpty()) {
                return;
            }
            float pix = 0.0625f;
            float center = 8.0f * pix;
            float length = 4.0f * pix;
            float width = 2.0f * pix;
            float thickness = 4.0f * pix;
            float[][] plugA = new float[3][2];
            float[][] plugB = new float[3][2];
            plugA[0][0] = center - length;
            plugA[0][1] = center + length;
            plugA[1][0] = 0.001f;
            plugA[1][1] = thickness;
            plugA[2][0] = center - width;
            plugA[2][1] = center + width;
            plugB[0][0] = center - width;
            plugB[0][1] = center + width;
            plugB[1][0] = 0.001f;
            plugB[1][1] = thickness;
            plugB[2][0] = center - length;
            plugB[2][1] = center + length;
            for (ForgeDirection dir : plugCons) {
                float[][] rotated = MatrixTransformations.deepClone(plugA);
                MatrixTransformations.transform(rotated, dir);
                block.func_149676_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
                rotated = MatrixTransformations.deepClone(plugB);
                MatrixTransformations.transform(rotated, dir);
                block.func_149676_a(rotated[0][0], rotated[1][0], rotated[2][0], rotated[0][1], rotated[1][1], rotated[2][1]);
                RenderTools.renderStandardBlock(renderblocks, block, x, y, z);
            }
        }

        @Override
        public void renderItem(RenderBlocks renderblocks, ItemStack item, IItemRenderer.ItemRenderType renderType) {
            float pix = 0.0625f;
            float max = 0.999f;
            float min = 0.001f;
            this.info.setBlockBounds(6.0f * pix, min, 6.0f * pix, 10.0f * pix, max, 10.0f * pix);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
            this.info.setBlockBounds(6.0f * pix - 1.0E-4f, 6.0f * pix - 1.0E-4f, min, 10.0f * pix + 1.0E-4f, 10.0f * pix + 1.0E-4f, max);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
            this.info.setBlockBounds(min, 6.0f * pix - 2.0E-4f, 6.0f * pix - 2.0E-4f, max, 10.0f * pix + 2.0E-4f, 10.0f * pix + 2.0E-4f);
            RenderFakeBlock.renderBlockOnInventory(renderblocks, this.info, 1.0f);
        }
    }
}

