/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import net.malisis.core.renderer.icon.MalisisIcon;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ConnectedTextureIcon
extends MalisisIcon {
    private static int NONE = 0;
    private static int LEFT = 1;
    private static int TOP = 2;
    private static int RIGHT = 4;
    private static int BOTTOM = 8;
    private static int FULL = LEFT | TOP | RIGHT | BOTTOM;
    public static ForgeDirection[][] sides = new ForgeDirection[][]{{ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH}, {ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH}, {ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.DOWN}, {ForgeDirection.WEST, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.DOWN}, {ForgeDirection.NORTH, ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.DOWN}, {ForgeDirection.SOUTH, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.DOWN}};
    private MalisisIcon[] icons = new MalisisIcon[16];

    public ConnectedTextureIcon(String name, MalisisIcon part1, MalisisIcon part2) {
        super(name);
        part1.addDependant(this);
        part2.addDependant(this);
    }

    public ConnectedTextureIcon(TextureMap register, String name) {
        super(name);
        MalisisIcon part1 = new MalisisIcon(name);
        MalisisIcon part2 = new MalisisIcon(name + "2");
        part1.addDependant(this);
        part2.addDependant(this);
        register.setTextureEntry(name, (TextureAtlasSprite)part1);
        register.setTextureEntry(name + "2", (TextureAtlasSprite)part2);
    }

    @Override
    protected void initIcon(MalisisIcon icon, int width, int height, int x, int y, boolean rotated) {
        float f = 0.33333334f;
        if (icon.func_94215_i().equals(this.func_94215_i())) {
            this.icons[ConnectedTextureIcon.LEFT | ConnectedTextureIcon.TOP] = icon.copy().clip(0.0f, 0.0f, f, f);
            this.icons[ConnectedTextureIcon.TOP] = icon.copy().clip(f, 0.0f, f, f);
            this.icons[ConnectedTextureIcon.RIGHT | ConnectedTextureIcon.TOP] = icon.copy().clip(2.0f * f, 0.0f, f, f);
            this.icons[ConnectedTextureIcon.LEFT] = icon.copy().clip(0.0f, f, f, f);
            this.icons[ConnectedTextureIcon.NONE] = icon.copy().clip(f, f, f, f);
            this.icons[ConnectedTextureIcon.RIGHT] = icon.copy().clip(2.0f * f, f, f, f);
            this.icons[ConnectedTextureIcon.LEFT | ConnectedTextureIcon.BOTTOM] = icon.copy().clip(0.0f, 2.0f * f, f, f);
            this.icons[ConnectedTextureIcon.BOTTOM] = icon.copy().clip(f, 2.0f * f, f, f);
            this.icons[ConnectedTextureIcon.RIGHT | ConnectedTextureIcon.BOTTOM] = icon.copy().clip(2.0f * f, 2.0f * f, f, f);
        } else {
            this.icons[ConnectedTextureIcon.LEFT | ConnectedTextureIcon.TOP | ConnectedTextureIcon.BOTTOM] = icon.copy().clip(0.0f, 0.0f, f, f);
            this.icons[ConnectedTextureIcon.TOP | ConnectedTextureIcon.BOTTOM] = icon.copy().clip(f, 0.0f, f, f);
            this.icons[ConnectedTextureIcon.LEFT | ConnectedTextureIcon.RIGHT | ConnectedTextureIcon.TOP] = icon.copy().clip(2.0f * f, 0.0f, f, f);
            this.icons[ConnectedTextureIcon.LEFT | ConnectedTextureIcon.RIGHT] = icon.copy().clip(0.0f, f, f, f);
            this.icons[ConnectedTextureIcon.FULL] = icon.copy().clip(f, f, f, f);
            this.icons[ConnectedTextureIcon.LEFT | ConnectedTextureIcon.RIGHT | ConnectedTextureIcon.BOTTOM] = icon.copy().clip(0.0f, 2.0f * f, f, f);
            this.icons[ConnectedTextureIcon.RIGHT | ConnectedTextureIcon.TOP | ConnectedTextureIcon.BOTTOM] = icon.copy().clip(2.0f * f, 2.0f * f, f, f);
        }
    }

    public IIcon getFullIcon() {
        return this.icons[FULL];
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        int connections = this.getConnections(world, x, y, z, side);
        return this.icons[connections];
    }

    private int getConnections(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        int connection = 0;
        for (int i = 0; i < 4; ++i) {
            if (world.func_147439_a(x + ConnectedTextureIcon.sides[dir.ordinal()][i].offsetX, y + ConnectedTextureIcon.sides[dir.ordinal()][i].offsetY, z + ConnectedTextureIcon.sides[dir.ordinal()][i].offsetZ) != block) continue;
            connection |= 1 << i;
        }
        return ~connection & 0xF;
    }

    @Override
    public void func_110971_a(int width, int height, int x, int y, boolean rotated) {
    }
}

